/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum FlowDirectiveEnum {
    CONTINUE("continue"),
    EXIT("exit"),
    END("end");

    private final String value;
    private static final Map<String, FlowDirectiveEnum> CONSTANTS;

    private FlowDirectiveEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static FlowDirectiveEnum fromValue(String value) {
        FlowDirectiveEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, FlowDirectiveEnum>();
        for (FlowDirectiveEnum c : FlowDirectiveEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

