/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.ForTaskConfiguration;
import io.serverlessworkflow.api.types.TaskBase;
import io.serverlessworkflow.api.types.TaskItem;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"for", "while", "do"})
public class ForTask
extends TaskBase
implements Serializable {
    @JsonProperty(value="for")
    @JsonPropertyDescription(value="The definition of the loop that iterates over a range of values.")
    @Valid
    @NotNull
    private ForTaskConfiguration _for;
    @JsonProperty(value="while")
    @JsonPropertyDescription(value="A runtime expression that represents the condition, if any, that must be met for the iteration to continue.")
    private String _while;
    @JsonProperty(value="do")
    @JsonPropertyDescription(value="List of named tasks to perform.")
    @Valid
    @NotNull
    private List<TaskItem> _do = new ArrayList<TaskItem>();
    private static final long serialVersionUID = 7737935378515942739L;

    public ForTask() {
    }

    public ForTask(ForTaskConfiguration _for, List<TaskItem> _do) {
        this._for = _for;
        this._do = _do;
    }

    @JsonProperty(value="for")
    public ForTaskConfiguration getFor() {
        return this._for;
    }

    @JsonProperty(value="for")
    public void setFor(ForTaskConfiguration _for) {
        this._for = _for;
    }

    public ForTask withFor(ForTaskConfiguration _for) {
        this._for = _for;
        return this;
    }

    @JsonProperty(value="while")
    public String getWhile() {
        return this._while;
    }

    @JsonProperty(value="while")
    public void setWhile(String _while) {
        this._while = _while;
    }

    public ForTask withWhile(String _while) {
        this._while = _while;
        return this;
    }

    @JsonProperty(value="do")
    public List<TaskItem> getDo() {
        return this._do;
    }

    @JsonProperty(value="do")
    public void setDo(List<TaskItem> _do) {
        this._do = _do;
    }

    public ForTask withDo(List<TaskItem> _do) {
        this._do = _do;
        return this;
    }
}

