/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.TaskItem;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"branches", "compete"})
public class ForkTaskConfiguration
implements Serializable {
    @JsonProperty(value="branches")
    @JsonPropertyDescription(value="List of named tasks to perform.")
    @Valid
    @NotNull
    private List<TaskItem> branches = new ArrayList<TaskItem>();
    @JsonProperty(value="compete")
    @JsonPropertyDescription(value="Indicates whether or not the concurrent tasks are racing against each other, with a single possible winner, which sets the composite task's output.")
    private boolean compete = false;
    private static final long serialVersionUID = -8929643648679256252L;

    public ForkTaskConfiguration() {
    }

    public ForkTaskConfiguration(List<TaskItem> branches) {
        this.branches = branches;
    }

    @JsonProperty(value="branches")
    public List<TaskItem> getBranches() {
        return this.branches;
    }

    @JsonProperty(value="branches")
    public void setBranches(List<TaskItem> branches) {
        this.branches = branches;
    }

    public ForkTaskConfiguration withBranches(List<TaskItem> branches) {
        this.branches = branches;
        return this;
    }

    @JsonProperty(value="compete")
    public boolean isCompete() {
        return this.compete;
    }

    @JsonProperty(value="compete")
    public void setCompete(boolean compete) {
        this.compete = compete;
    }

    public ForkTaskConfiguration withCompete(boolean compete) {
        this.compete = compete;
        return this;
    }
}

