/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.ExternalResource;
import io.serverlessworkflow.api.types.WithGRPCArguments;
import io.serverlessworkflow.api.types.WithGRPCService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"proto", "service", "method", "arguments"})
public class GRPCArguments
implements Serializable {
    @JsonProperty(value="proto")
    @JsonPropertyDescription(value="Represents an external resource.")
    @Valid
    @NotNull
    private ExternalResource proto;
    @JsonProperty(value="service")
    @Valid
    @NotNull
    private WithGRPCService service;
    @JsonProperty(value="method")
    @JsonPropertyDescription(value="The name of the method to call on the defined GRPC service.")
    @NotNull
    private String method;
    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="The arguments, if any, to call the method with.")
    @Valid
    private WithGRPCArguments arguments;
    private static final long serialVersionUID = 6815571419819663852L;

    public GRPCArguments() {
    }

    public GRPCArguments(ExternalResource proto, WithGRPCService service, String method) {
        this.proto = proto;
        this.service = service;
        this.method = method;
    }

    @JsonProperty(value="proto")
    public ExternalResource getProto() {
        return this.proto;
    }

    @JsonProperty(value="proto")
    public void setProto(ExternalResource proto) {
        this.proto = proto;
    }

    public GRPCArguments withProto(ExternalResource proto) {
        this.proto = proto;
        return this;
    }

    @JsonProperty(value="service")
    public WithGRPCService getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(WithGRPCService service) {
        this.service = service;
    }

    public GRPCArguments withService(WithGRPCService service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="method")
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    public void setMethod(String method) {
        this.method = method;
    }

    public GRPCArguments withMethod(String method) {
        this.method = method;
        return this;
    }

    @JsonProperty(value="arguments")
    public WithGRPCArguments getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    public void setArguments(WithGRPCArguments arguments) {
        this.arguments = arguments;
    }

    public GRPCArguments withArguments(WithGRPCArguments arguments) {
        this.arguments = arguments;
        return this;
    }
}

