/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.types.Endpoint;
import io.serverlessworkflow.api.types.HTTPHeaders;
import io.serverlessworkflow.api.types.HTTPQuery;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"method", "endpoint", "headers", "body", "query", "output", "redirect"})
public class HTTPArguments
implements Serializable {
    @JsonProperty(value="method")
    @JsonPropertyDescription(value="The HTTP method of the HTTP request to perform.")
    @NotNull
    private String method;
    @JsonProperty(value="endpoint")
    @JsonPropertyDescription(value="Represents an endpoint.")
    @NotNull
    private Endpoint endpoint;
    @JsonProperty(value="headers")
    @JsonPropertyDescription(value="A name/value mapping of the headers, if any, of the HTTP request to perform.")
    @Valid
    private HTTPHeaders headers;
    @JsonProperty(value="body")
    @JsonPropertyDescription(value="The body, if any, of the HTTP request to perform.")
    private Object body;
    @JsonProperty(value="query")
    @JsonPropertyDescription(value="A name/value mapping of the query parameters, if any, of the HTTP request to perform.")
    @Valid
    private HTTPQuery query;
    @JsonProperty(value="output")
    @JsonPropertyDescription(value="The http call output format. Defaults to 'content'.")
    private HTTPOutput output;
    @JsonProperty(value="redirect")
    @JsonPropertyDescription(value="Specifies whether redirection status codes (`300\u2013399`) should be treated as errors.")
    private boolean redirect;
    private static final long serialVersionUID = 5322841826904021683L;

    public HTTPArguments() {
    }

    public HTTPArguments(String method, Endpoint endpoint) {
        this.method = method;
        this.endpoint = endpoint;
    }

    @JsonProperty(value="method")
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    public void setMethod(String method) {
        this.method = method;
    }

    public HTTPArguments withMethod(String method) {
        this.method = method;
        return this;
    }

    @JsonProperty(value="endpoint")
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public HTTPArguments withEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonProperty(value="headers")
    public HTTPHeaders getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    public void setHeaders(HTTPHeaders headers) {
        this.headers = headers;
    }

    public HTTPArguments withHeaders(HTTPHeaders headers) {
        this.headers = headers;
        return this;
    }

    @JsonProperty(value="body")
    public Object getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    public void setBody(Object body) {
        this.body = body;
    }

    public HTTPArguments withBody(Object body) {
        this.body = body;
        return this;
    }

    @JsonProperty(value="query")
    public HTTPQuery getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    public void setQuery(HTTPQuery query) {
        this.query = query;
    }

    public HTTPArguments withQuery(HTTPQuery query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="output")
    public HTTPOutput getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    public void setOutput(HTTPOutput output) {
        this.output = output;
    }

    public HTTPArguments withOutput(HTTPOutput output) {
        this.output = output;
        return this;
    }

    @JsonProperty(value="redirect")
    public boolean isRedirect() {
        return this.redirect;
    }

    @JsonProperty(value="redirect")
    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public HTTPArguments withRedirect(boolean redirect) {
        this.redirect = redirect;
        return this;
    }

    public static enum HTTPOutput {
        RAW("raw"),
        CONTENT("content"),
        RESPONSE("response");

        private final String value;
        private static final Map<String, HTTPOutput> CONSTANTS;

        private HTTPOutput(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static HTTPOutput fromValue(String value) {
            HTTPOutput constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, HTTPOutput>();
            for (HTTPOutput c : HTTPOutput.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

