/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.types.ListenTo;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"to", "read"})
public class ListenTaskConfiguration
implements Serializable {
    @JsonProperty(value="to")
    @JsonPropertyDescription(value="Describe the event consumption strategy to adopt.")
    @Valid
    @NotNull
    private ListenTo to;
    @JsonProperty(value="read")
    @JsonPropertyDescription(value="Specifies how events are read during the listen operation.")
    private ListenAndReadAs read = ListenAndReadAs.fromValue("data");
    private static final long serialVersionUID = 2094001426476418643L;

    public ListenTaskConfiguration() {
    }

    public ListenTaskConfiguration(ListenTo to) {
        this.to = to;
    }

    @JsonProperty(value="to")
    public ListenTo getTo() {
        return this.to;
    }

    @JsonProperty(value="to")
    public void setTo(ListenTo to) {
        this.to = to;
    }

    public ListenTaskConfiguration withTo(ListenTo to) {
        this.to = to;
        return this;
    }

    @JsonProperty(value="read")
    public ListenAndReadAs getRead() {
        return this.read;
    }

    @JsonProperty(value="read")
    public void setRead(ListenAndReadAs read) {
        this.read = read;
    }

    public ListenTaskConfiguration withRead(ListenAndReadAs read) {
        this.read = read;
        return this;
    }

    public static enum ListenAndReadAs {
        DATA("data"),
        ENVELOPE("envelope"),
        RAW("raw");

        private final String value;
        private static final Map<String, ListenAndReadAs> CONSTANTS;

        private ListenAndReadAs(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ListenAndReadAs fromValue(String value) {
            ListenAndReadAs constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ListenAndReadAs>();
            for (ListenAndReadAs c : ListenAndReadAs.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

