/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.types.OAuth2AutenthicationDataClient;
import io.serverlessworkflow.api.types.OAuth2TokenDefinition;
import io.serverlessworkflow.api.types.OAuth2TokenRequest;
import io.serverlessworkflow.api.types.UriTemplate;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"authority", "grant", "client", "request", "issuers", "scopes", "audiences", "username", "password", "subject", "actor"})
public class OAuth2AutenthicationData
implements Serializable {
    @JsonProperty(value="authority")
    private UriTemplate authority;
    @JsonProperty(value="grant")
    @JsonPropertyDescription(value="The grant type to use.")
    private OAuth2AutenthicationDataGrant grant;
    @JsonProperty(value="client")
    @JsonPropertyDescription(value="The definition of an OAuth2 client.")
    @Valid
    private OAuth2AutenthicationDataClient client;
    @JsonProperty(value="request")
    @JsonPropertyDescription(value="The configuration of an OAuth2 token request")
    @Valid
    private OAuth2TokenRequest request;
    @JsonProperty(value="issuers")
    @JsonPropertyDescription(value="A list that contains that contains valid issuers that will be used to check against the issuer of generated tokens.")
    @Valid
    private List<String> issuers = new ArrayList<String>();
    @JsonProperty(value="scopes")
    @JsonPropertyDescription(value="The scopes, if any, to request the token for.")
    @Valid
    private List<String> scopes = new ArrayList<String>();
    @JsonProperty(value="audiences")
    @JsonPropertyDescription(value="The audiences, if any, to request the token for.")
    @Valid
    private List<String> audiences = new ArrayList<String>();
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="The username to use. Used only if the grant type is Password.")
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="The password to use. Used only if the grant type is Password.")
    private String password;
    @JsonProperty(value="subject")
    @JsonPropertyDescription(value="Represents an OAuth2 token.")
    @Valid
    private OAuth2TokenDefinition subject;
    @JsonProperty(value="actor")
    @JsonPropertyDescription(value="Represents an OAuth2 token.")
    @Valid
    private OAuth2TokenDefinition actor;
    private static final long serialVersionUID = -2195227164396101725L;

    @JsonProperty(value="authority")
    public UriTemplate getAuthority() {
        return this.authority;
    }

    @JsonProperty(value="authority")
    public void setAuthority(UriTemplate authority) {
        this.authority = authority;
    }

    public OAuth2AutenthicationData withAuthority(UriTemplate authority) {
        this.authority = authority;
        return this;
    }

    @JsonProperty(value="grant")
    public OAuth2AutenthicationDataGrant getGrant() {
        return this.grant;
    }

    @JsonProperty(value="grant")
    public void setGrant(OAuth2AutenthicationDataGrant grant) {
        this.grant = grant;
    }

    public OAuth2AutenthicationData withGrant(OAuth2AutenthicationDataGrant grant) {
        this.grant = grant;
        return this;
    }

    @JsonProperty(value="client")
    public OAuth2AutenthicationDataClient getClient() {
        return this.client;
    }

    @JsonProperty(value="client")
    public void setClient(OAuth2AutenthicationDataClient client) {
        this.client = client;
    }

    public OAuth2AutenthicationData withClient(OAuth2AutenthicationDataClient client) {
        this.client = client;
        return this;
    }

    @JsonProperty(value="request")
    public OAuth2TokenRequest getRequest() {
        return this.request;
    }

    @JsonProperty(value="request")
    public void setRequest(OAuth2TokenRequest request) {
        this.request = request;
    }

    public OAuth2AutenthicationData withRequest(OAuth2TokenRequest request) {
        this.request = request;
        return this;
    }

    @JsonProperty(value="issuers")
    public List<String> getIssuers() {
        return this.issuers;
    }

    @JsonProperty(value="issuers")
    public void setIssuers(List<String> issuers) {
        this.issuers = issuers;
    }

    public OAuth2AutenthicationData withIssuers(List<String> issuers) {
        this.issuers = issuers;
        return this;
    }

    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public OAuth2AutenthicationData withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    @JsonProperty(value="audiences")
    public List<String> getAudiences() {
        return this.audiences;
    }

    @JsonProperty(value="audiences")
    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public OAuth2AutenthicationData withAudiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public OAuth2AutenthicationData withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public OAuth2AutenthicationData withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="subject")
    public OAuth2TokenDefinition getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(OAuth2TokenDefinition subject) {
        this.subject = subject;
    }

    public OAuth2AutenthicationData withSubject(OAuth2TokenDefinition subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty(value="actor")
    public OAuth2TokenDefinition getActor() {
        return this.actor;
    }

    @JsonProperty(value="actor")
    public void setActor(OAuth2TokenDefinition actor) {
        this.actor = actor;
    }

    public OAuth2AutenthicationData withActor(OAuth2TokenDefinition actor) {
        this.actor = actor;
        return this;
    }

    public static enum OAuth2AutenthicationDataGrant {
        AUTHORIZATION_CODE("authorization_code"),
        CLIENT_CREDENTIALS("client_credentials"),
        PASSWORD("password"),
        REFRESH_TOKEN("refresh_token"),
        URN_IETF_PARAMS_OAUTH_GRANT_TYPE_TOKEN_EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange");

        private final String value;
        private static final Map<String, OAuth2AutenthicationDataGrant> CONSTANTS;

        private OAuth2AutenthicationDataGrant(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OAuth2AutenthicationDataGrant fromValue(String value) {
            OAuth2AutenthicationDataGrant constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OAuth2AutenthicationDataGrant>();
            for (OAuth2AutenthicationDataGrant c : OAuth2AutenthicationDataGrant.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

