/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "secret", "assertion", "authentication"})
public class OAuth2AutenthicationDataClient
implements Serializable {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="The client id to use.")
    private String id;
    @JsonProperty(value="secret")
    @JsonPropertyDescription(value="The client secret to use, if any.")
    private String secret;
    @JsonProperty(value="assertion")
    @JsonPropertyDescription(value="A JWT containing a signed assertion with your application credentials.")
    private String assertion;
    @JsonProperty(value="authentication")
    @JsonPropertyDescription(value="The authentication method to use to authenticate the client.")
    private ClientAuthentication authentication = ClientAuthentication.fromValue("client_secret_post");
    private static final long serialVersionUID = 8554699705317304904L;

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public OAuth2AutenthicationDataClient withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    public void setSecret(String secret) {
        this.secret = secret;
    }

    public OAuth2AutenthicationDataClient withSecret(String secret) {
        this.secret = secret;
        return this;
    }

    @JsonProperty(value="assertion")
    public String getAssertion() {
        return this.assertion;
    }

    @JsonProperty(value="assertion")
    public void setAssertion(String assertion) {
        this.assertion = assertion;
    }

    public OAuth2AutenthicationDataClient withAssertion(String assertion) {
        this.assertion = assertion;
        return this;
    }

    @JsonProperty(value="authentication")
    public ClientAuthentication getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    public void setAuthentication(ClientAuthentication authentication) {
        this.authentication = authentication;
    }

    public OAuth2AutenthicationDataClient withAuthentication(ClientAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public static enum ClientAuthentication {
        CLIENT_SECRET_BASIC("client_secret_basic"),
        CLIENT_SECRET_POST("client_secret_post"),
        CLIENT_SECRET_JWT("client_secret_jwt"),
        PRIVATE_KEY_JWT("private_key_jwt"),
        NONE("none");

        private final String value;
        private static final Map<String, ClientAuthentication> CONSTANTS;

        private ClientAuthentication(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ClientAuthentication fromValue(String value) {
            ClientAuthentication constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ClientAuthentication>();
            for (ClientAuthentication c : ClientAuthentication.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

