/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"encoding"})
public class OAuth2TokenRequest
implements Serializable {
    @JsonProperty(value="encoding")
    private Oauth2TokenRequestEncoding encoding = Oauth2TokenRequestEncoding.fromValue("application/x-www-form-urlencoded");
    private static final long serialVersionUID = -7277792680592967951L;

    @JsonProperty(value="encoding")
    public Oauth2TokenRequestEncoding getEncoding() {
        return this.encoding;
    }

    @JsonProperty(value="encoding")
    public void setEncoding(Oauth2TokenRequestEncoding encoding) {
        this.encoding = encoding;
    }

    public OAuth2TokenRequest withEncoding(Oauth2TokenRequestEncoding encoding) {
        this.encoding = encoding;
        return this;
    }

    public static enum Oauth2TokenRequestEncoding {
        APPLICATION_X_WWW_FORM_URLENCODED("application/x-www-form-urlencoded"),
        APPLICATION_JSON("application/json");

        private final String value;
        private static final Map<String, Oauth2TokenRequestEncoding> CONSTANTS;

        private Oauth2TokenRequestEncoding(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Oauth2TokenRequestEncoding fromValue(String value) {
            Oauth2TokenRequestEncoding constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Oauth2TokenRequestEncoding>();
            for (Oauth2TokenRequestEncoding c : Oauth2TokenRequestEncoding.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

