/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.types.ExternalResource;
import io.serverlessworkflow.api.types.ReferenceableAuthenticationPolicy;
import io.serverlessworkflow.api.types.WithOpenAPIParameters;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"document", "operationId", "parameters", "authentication", "output", "redirect"})
public class OpenAPIArguments
implements Serializable {
    @JsonProperty(value="document")
    @JsonPropertyDescription(value="Represents an external resource.")
    @Valid
    @NotNull
    private ExternalResource document;
    @JsonProperty(value="operationId")
    @JsonPropertyDescription(value="The id of the OpenAPI operation to call.")
    @NotNull
    private String operationId;
    @JsonProperty(value="parameters")
    @JsonPropertyDescription(value="A name/value mapping of the parameters of the OpenAPI operation to call.")
    @Valid
    private WithOpenAPIParameters parameters;
    @JsonProperty(value="authentication")
    @JsonPropertyDescription(value="Represents a referenceable authentication policy.")
    @Valid
    private ReferenceableAuthenticationPolicy authentication;
    @JsonProperty(value="output")
    @JsonPropertyDescription(value="The http call output format. Defaults to 'content'.")
    private WithOpenAPIOutput output;
    @JsonProperty(value="redirect")
    @JsonPropertyDescription(value="Specifies whether redirection status codes (`300\u2013399`) should be treated as errors.")
    private boolean redirect;
    private static final long serialVersionUID = 3103791886700186674L;

    public OpenAPIArguments() {
    }

    public OpenAPIArguments(ExternalResource document, String operationId) {
        this.document = document;
        this.operationId = operationId;
    }

    @JsonProperty(value="document")
    public ExternalResource getDocument() {
        return this.document;
    }

    @JsonProperty(value="document")
    public void setDocument(ExternalResource document) {
        this.document = document;
    }

    public OpenAPIArguments withDocument(ExternalResource document) {
        this.document = document;
        return this;
    }

    @JsonProperty(value="operationId")
    public String getOperationId() {
        return this.operationId;
    }

    @JsonProperty(value="operationId")
    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public OpenAPIArguments withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    @JsonProperty(value="parameters")
    public WithOpenAPIParameters getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(WithOpenAPIParameters parameters) {
        this.parameters = parameters;
    }

    public OpenAPIArguments withParameters(WithOpenAPIParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @JsonProperty(value="authentication")
    public ReferenceableAuthenticationPolicy getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    public void setAuthentication(ReferenceableAuthenticationPolicy authentication) {
        this.authentication = authentication;
    }

    public OpenAPIArguments withAuthentication(ReferenceableAuthenticationPolicy authentication) {
        this.authentication = authentication;
        return this;
    }

    @JsonProperty(value="output")
    public WithOpenAPIOutput getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    public void setOutput(WithOpenAPIOutput output) {
        this.output = output;
    }

    public OpenAPIArguments withOutput(WithOpenAPIOutput output) {
        this.output = output;
        return this;
    }

    @JsonProperty(value="redirect")
    public boolean isRedirect() {
        return this.redirect;
    }

    @JsonProperty(value="redirect")
    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public OpenAPIArguments withRedirect(boolean redirect) {
        this.redirect = redirect;
        return this;
    }

    public static enum WithOpenAPIOutput {
        RAW("raw"),
        CONTENT("content"),
        RESPONSE("response");

        private final String value;
        private static final Map<String, WithOpenAPIOutput> CONSTANTS;

        private WithOpenAPIOutput(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static WithOpenAPIOutput fromValue(String value) {
            WithOpenAPIOutput constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, WithOpenAPIOutput>();
            for (WithOpenAPIOutput c : WithOpenAPIOutput.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

