/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.RetryBackoff;
import io.serverlessworkflow.api.types.RetryLimit;
import io.serverlessworkflow.api.types.RetryPolicyJitter;
import io.serverlessworkflow.api.types.TimeoutAfter;
import jakarta.validation.Valid;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"when", "exceptWhen", "delay", "backoff", "limit", "jitter"})
public class RetryPolicy
implements Serializable {
    @JsonProperty(value="when")
    @JsonPropertyDescription(value="A runtime expression, if any, used to determine whether or not to retry running the task, in a given context.")
    private String when;
    @JsonProperty(value="exceptWhen")
    @JsonPropertyDescription(value="A runtime expression used to determine whether or not to retry running the task, in a given context.")
    private String exceptWhen;
    @JsonProperty(value="delay")
    private TimeoutAfter delay;
    @JsonProperty(value="backoff")
    @JsonPropertyDescription(value="The retry duration backoff.")
    @Valid
    private RetryBackoff backoff;
    @JsonProperty(value="limit")
    @JsonPropertyDescription(value="The retry limit, if any.")
    @Valid
    private RetryLimit limit;
    @JsonProperty(value="jitter")
    @JsonPropertyDescription(value="The parameters, if any, that control the randomness or variability of the delay between retry attempts.")
    @Valid
    private RetryPolicyJitter jitter;
    private static final long serialVersionUID = -2177482832576297936L;

    @JsonProperty(value="when")
    public String getWhen() {
        return this.when;
    }

    @JsonProperty(value="when")
    public void setWhen(String when) {
        this.when = when;
    }

    public RetryPolicy withWhen(String when) {
        this.when = when;
        return this;
    }

    @JsonProperty(value="exceptWhen")
    public String getExceptWhen() {
        return this.exceptWhen;
    }

    @JsonProperty(value="exceptWhen")
    public void setExceptWhen(String exceptWhen) {
        this.exceptWhen = exceptWhen;
    }

    public RetryPolicy withExceptWhen(String exceptWhen) {
        this.exceptWhen = exceptWhen;
        return this;
    }

    @JsonProperty(value="delay")
    public TimeoutAfter getDelay() {
        return this.delay;
    }

    @JsonProperty(value="delay")
    public void setDelay(TimeoutAfter delay) {
        this.delay = delay;
    }

    public RetryPolicy withDelay(TimeoutAfter delay) {
        this.delay = delay;
        return this;
    }

    @JsonProperty(value="backoff")
    public RetryBackoff getBackoff() {
        return this.backoff;
    }

    @JsonProperty(value="backoff")
    public void setBackoff(RetryBackoff backoff) {
        this.backoff = backoff;
    }

    public RetryPolicy withBackoff(RetryBackoff backoff) {
        this.backoff = backoff;
        return this;
    }

    @JsonProperty(value="limit")
    public RetryLimit getLimit() {
        return this.limit;
    }

    @JsonProperty(value="limit")
    public void setLimit(RetryLimit limit) {
        this.limit = limit;
    }

    public RetryPolicy withLimit(RetryLimit limit) {
        this.limit = limit;
        return this;
    }

    @JsonProperty(value="jitter")
    public RetryPolicyJitter getJitter() {
        return this.jitter;
    }

    @JsonProperty(value="jitter")
    public void setJitter(RetryPolicyJitter jitter) {
        this.jitter = jitter;
    }

    public RetryPolicy withJitter(RetryPolicyJitter jitter) {
        this.jitter = jitter;
        return this;
    }
}

