/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"await", "return"})
public class RunTaskConfiguration
implements Serializable {
    @JsonProperty(value="await")
    @JsonPropertyDescription(value="Whether to await the process completion before continuing.")
    private boolean await = true;
    @JsonProperty(value="return")
    @JsonPropertyDescription(value="Configures the output of the process.")
    private ProcessReturnType _return = ProcessReturnType.fromValue("stdout");
    private static final long serialVersionUID = 7056334955865298509L;

    @JsonProperty(value="await")
    public boolean isAwait() {
        return this.await;
    }

    @JsonProperty(value="await")
    public void setAwait(boolean await) {
        this.await = await;
    }

    public RunTaskConfiguration withAwait(boolean await) {
        this.await = await;
        return this;
    }

    @JsonProperty(value="return")
    public ProcessReturnType getReturn() {
        return this._return;
    }

    @JsonProperty(value="return")
    public void setReturn(ProcessReturnType _return) {
        this._return = _return;
    }

    public RunTaskConfiguration withReturn(ProcessReturnType _return) {
        this._return = _return;
        return this;
    }

    public static enum ProcessReturnType {
        STDOUT("stdout"),
        STDERR("stderr"),
        CODE("code"),
        ALL("all"),
        NONE("none");

        private final String value;
        private static final Map<String, ProcessReturnType> CONSTANTS;

        private ProcessReturnType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProcessReturnType fromValue(String value) {
            ProcessReturnType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ProcessReturnType>();
            for (ProcessReturnType c : ProcessReturnType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

