/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.ScriptArguments;
import io.serverlessworkflow.api.types.ScriptEnvironment;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"language", "arguments", "environment"})
public class Script
implements Serializable {
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="The language of the script to run.")
    @NotNull
    private String language;
    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="A key/value mapping of the arguments, if any, to use when running the configured script.")
    @Valid
    private ScriptArguments arguments;
    @JsonProperty(value="environment")
    @JsonPropertyDescription(value="A key/value mapping of the environment variables, if any, to use when running the configured script process.")
    @Valid
    private ScriptEnvironment environment;
    private static final long serialVersionUID = 7938356327697911103L;

    public Script() {
    }

    public Script(String language) {
        this.language = language;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public Script withLanguage(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="arguments")
    public ScriptArguments getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    public void setArguments(ScriptArguments arguments) {
        this.arguments = arguments;
    }

    public Script withArguments(ScriptArguments arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonProperty(value="environment")
    public ScriptEnvironment getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    public void setEnvironment(ScriptEnvironment environment) {
        this.environment = environment;
    }

    public Script withEnvironment(ScriptEnvironment environment) {
        this.environment = environment;
        return this;
    }
}

