/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.ShellArguments;
import io.serverlessworkflow.api.types.ShellEnvironment;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"command", "arguments", "environment"})
public class Shell
implements Serializable {
    @JsonProperty(value="command")
    @JsonPropertyDescription(value="The shell command to run.")
    @NotNull
    private String command;
    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="A list of the arguments of the shell command to run.")
    @Valid
    private ShellArguments arguments;
    @JsonProperty(value="environment")
    @JsonPropertyDescription(value="A key/value mapping of the environment variables, if any, to use when running the configured process.")
    @Valid
    private ShellEnvironment environment;
    private static final long serialVersionUID = -4177945241442723917L;

    public Shell() {
    }

    public Shell(String command) {
        this.command = command;
    }

    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    @JsonProperty(value="command")
    public void setCommand(String command) {
        this.command = command;
    }

    public Shell withCommand(String command) {
        this.command = command;
        return this;
    }

    @JsonProperty(value="arguments")
    public ShellArguments getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    public void setArguments(ShellArguments arguments) {
        this.arguments = arguments;
    }

    public Shell withArguments(ShellArguments arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonProperty(value="environment")
    public ShellEnvironment getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    public void setEnvironment(ShellEnvironment environment) {
        this.environment = environment;
    }

    public Shell withEnvironment(ShellEnvironment environment) {
        this.environment = environment;
        return this;
    }
}

