/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.SubflowInput;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"namespace", "name", "version", "input"})
public class SubflowConfiguration
implements Serializable {
    @JsonProperty(value="namespace")
    @JsonPropertyDescription(value="The namespace the workflow to run belongs to.")
    @NotNull
    private String namespace;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the workflow to run.")
    @NotNull
    private String name;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="The version of the workflow to run. Defaults to latest.")
    @NotNull
    private String version = "latest";
    @JsonProperty(value="input")
    @JsonPropertyDescription(value="The data, if any, to pass as input to the workflow to execute. The value should be validated against the target workflow's input schema, if specified.")
    @Valid
    private SubflowInput input;
    private static final long serialVersionUID = -2918860046276868816L;

    public SubflowConfiguration() {
    }

    public SubflowConfiguration(String namespace, String name, String version) {
        this.namespace = namespace;
        this.name = name;
        this.version = version;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public SubflowConfiguration withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public SubflowConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public SubflowConfiguration withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="input")
    public SubflowInput getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    public void setInput(SubflowInput input) {
        this.input = input;
    }

    public SubflowConfiguration withInput(SubflowInput input) {
        this.input = input;
        return this;
    }
}

