/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.DurationInline;
import io.serverlessworkflow.api.types.TimeoutAfterDeserializer;
import io.serverlessworkflow.api.types.TimeoutAfterSerializer;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;

@JsonSerialize(using=TimeoutAfterSerializer.class)
@JsonDeserialize(using=TimeoutAfterDeserializer.class)
public class TimeoutAfter
implements OneOfValueProvider<Object> {
    private Object value;
    private DurationInline durationInline;
    private String durationExpression;
    private static final Pattern durationExpression_Pattern = Pattern.compile("^P(?!$)(\\d+(?:\\.\\d+)?Y)?(\\d+(?:\\.\\d+)?M)?(\\d+(?:\\.\\d+)?W)?(\\d+(?:\\.\\d+)?D)?(T(?=\\d)(\\d+(?:\\.\\d+)?H)?(\\d+(?:\\.\\d+)?M)?(\\d+(?:\\.\\d+)?S)?)?$");

    @Override
    public Object get() {
        return this.value;
    }

    public DurationInline getDurationInline() {
        return this.durationInline;
    }

    public TimeoutAfter withDurationInline(DurationInline value) {
        this.durationInline = value;
        return this;
    }

    @OneOfSetter(value=DurationInline.class)
    public void setDurationInline(DurationInline durationInline) {
        this.value = durationInline;
        this.durationInline = durationInline;
    }

    public String getDurationExpression() {
        return this.durationExpression;
    }

    public TimeoutAfter withDurationExpression(String value) {
        this.durationExpression = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setDurationExpression(String durationExpression) {
        this.value = durationExpression;
        if (!durationExpression_Pattern.matcher(durationExpression).matches()) {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", durationExpression), null);
        }
        this.durationExpression = durationExpression;
    }
}

