/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.UriTemplateDeserializer;
import io.serverlessworkflow.api.types.UriTemplateSerializer;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.net.URI;
import java.util.regex.Pattern;

@JsonSerialize(using=UriTemplateSerializer.class)
@JsonDeserialize(using=UriTemplateDeserializer.class)
public class UriTemplate
implements OneOfValueProvider<Object> {
    private Object value;
    private URI literalUri;
    private String literalUriTemplate;
    private static final Pattern literalUriTemplate_Pattern = Pattern.compile("^[A-Za-z][A-Za-z0-9+\\-.]*://.*");

    @Override
    public Object get() {
        return this.value;
    }

    public URI getLiteralUri() {
        return this.literalUri;
    }

    public UriTemplate withLiteralUri(URI value) {
        this.literalUri = value;
        return this;
    }

    @OneOfSetter(value=URI.class)
    public void setLiteralUri(URI literalUri) {
        this.value = literalUri;
        this.literalUri = literalUri;
    }

    public String getLiteralUriTemplate() {
        return this.literalUriTemplate;
    }

    public UriTemplate withLiteralUriTemplate(String value) {
        this.literalUriTemplate = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setLiteralUriTemplate(String literalUriTemplate) {
        this.value = literalUriTemplate;
        if (!literalUriTemplate_Pattern.matcher(literalUriTemplate).matches()) {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", literalUriTemplate), null);
        }
        this.literalUriTemplate = literalUriTemplate;
    }
}

