/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.ReferenceableAuthenticationPolicy;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "host", "port", "authentication"})
public class WithGRPCService
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the GRPC service to call.")
    @NotNull
    private String name;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="The hostname of the GRPC service to call.")
    @Pattern(regexp="^[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?$")
    @NotNull
    private @Pattern(regexp="^[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?$") @NotNull String host;
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="The port number of the GRPC service to call.")
    @DecimalMin(value="0")
    @DecimalMax(value="65535")
    private @DecimalMin(value="0") @DecimalMax(value="65535") int port;
    @JsonProperty(value="authentication")
    @JsonPropertyDescription(value="Represents a referenceable authentication policy.")
    @Valid
    private ReferenceableAuthenticationPolicy authentication;
    private static final long serialVersionUID = -4587144747811442743L;

    public WithGRPCService() {
    }

    public WithGRPCService(String name, String host) {
        this.name = name;
        this.host = host;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public WithGRPCService withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    public WithGRPCService withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="port")
    public int getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(int port) {
        this.port = port;
    }

    public WithGRPCService withPort(int port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="authentication")
    public ReferenceableAuthenticationPolicy getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    public void setAuthentication(ReferenceableAuthenticationPolicy authentication) {
        this.authentication = authentication;
    }

    public WithGRPCService withAuthentication(ReferenceableAuthenticationPolicy authentication) {
        this.authentication = authentication;
        return this;
    }
}

