/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.DoTimeout;
import io.serverlessworkflow.api.types.Document;
import io.serverlessworkflow.api.types.Input;
import io.serverlessworkflow.api.types.Output;
import io.serverlessworkflow.api.types.Schedule;
import io.serverlessworkflow.api.types.TaskItem;
import io.serverlessworkflow.api.types.Use;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"document", "input", "use", "do", "timeout", "output", "schedule"})
public class Workflow
implements Serializable {
    @JsonProperty(value="document")
    @JsonPropertyDescription(value="Documents the workflow.")
    @Valid
    @NotNull
    private Document document;
    @JsonProperty(value="input")
    @JsonPropertyDescription(value="Configures the input of a workflow or task.")
    @Valid
    private Input input;
    @JsonProperty(value="use")
    @JsonPropertyDescription(value="Defines the workflow's reusable components.")
    @Valid
    private Use use;
    @JsonProperty(value="do")
    @JsonPropertyDescription(value="List of named tasks to perform.")
    @Valid
    @NotNull
    private List<TaskItem> _do = new ArrayList<TaskItem>();
    @JsonProperty(value="timeout")
    private DoTimeout timeout;
    @JsonProperty(value="output")
    @JsonPropertyDescription(value="Configures the output of a workflow or task.")
    @Valid
    private Output output;
    @JsonProperty(value="schedule")
    @JsonPropertyDescription(value="Schedules the workflow.")
    @Valid
    private Schedule schedule;
    private static final long serialVersionUID = -9024292420012108146L;

    public Workflow() {
    }

    public Workflow(Document document, List<TaskItem> _do) {
        this.document = document;
        this._do = _do;
    }

    @JsonProperty(value="document")
    public Document getDocument() {
        return this.document;
    }

    @JsonProperty(value="document")
    public void setDocument(Document document) {
        this.document = document;
    }

    public Workflow withDocument(Document document) {
        this.document = document;
        return this;
    }

    @JsonProperty(value="input")
    public Input getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    public void setInput(Input input) {
        this.input = input;
    }

    public Workflow withInput(Input input) {
        this.input = input;
        return this;
    }

    @JsonProperty(value="use")
    public Use getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    public void setUse(Use use) {
        this.use = use;
    }

    public Workflow withUse(Use use) {
        this.use = use;
        return this;
    }

    @JsonProperty(value="do")
    public List<TaskItem> getDo() {
        return this._do;
    }

    @JsonProperty(value="do")
    public void setDo(List<TaskItem> _do) {
        this._do = _do;
    }

    public Workflow withDo(List<TaskItem> _do) {
        this._do = _do;
        return this;
    }

    @JsonProperty(value="timeout")
    public DoTimeout getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(DoTimeout timeout) {
        this.timeout = timeout;
    }

    public Workflow withTimeout(DoTimeout timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty(value="output")
    public Output getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    public void setOutput(Output output) {
        this.output = output;
    }

    public Workflow withOutput(Output output) {
        this.output = output;
        return this;
    }

    @JsonProperty(value="schedule")
    public Schedule getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public Workflow withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }
}

