/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.io.IOException;
import java.util.Set;

public class BeanDeserializerWithValidation
extends BeanDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    protected BeanDeserializerWithValidation(BeanDeserializerBase src) {
        super(src);
    }

    private <T> void validate(T t) throws IOException {
        Set violations = validator.validate(t, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object instance = super.deserialize(p, ctxt);
        this.validate(instance);
        return instance;
    }
}

