/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class DeserializeHelper {
    public static <T> T deserializeOneOf(JsonParser p, Class<T> targetClass, Collection<Class<?>> oneOfTypes) throws IOException {
        TreeNode node = p.readValueAsTree();
        try {
            T result = targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (Class<?> oneOfType : oneOfTypes) {
                try {
                    DeserializeHelper.assingIt(p, result, node, targetClass, oneOfType);
                    break;
                }
                catch (ConstraintViolationException | IOException | InvocationTargetException ex) {
                    exceptions.add(ex);
                }
            }
            if (exceptions.size() == oneOfTypes.size()) {
                JsonMappingException ex = new JsonMappingException((Closeable)p, String.format("Error deserializing class %s, all oneOf alternatives %s has failed ", targetClass, oneOfTypes));
                exceptions.forEach(arg_0 -> ex.addSuppressed(arg_0));
                throw ex;
            }
            return result;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static <T> void assingIt(JsonParser p, T result, TreeNode node, Class<T> targetClass, Class<?> type) throws JsonProcessingException, ReflectiveOperationException {
        DeserializeHelper.findSetMethod(targetClass, type).invoke(result, p.getCodec().treeToValue(node, type));
    }

    private static Method findSetMethod(Class<?> targetClass, Class<?> type) {
        for (Method method : targetClass.getMethods()) {
            OneOfSetter oneOfSetter = method.getAnnotation(OneOfSetter.class);
            if (oneOfSetter == null || !type.equals(oneOfSetter.value())) continue;
            return method;
        }
        throw new IllegalStateException("Cannot find a setter for type " + String.valueOf(type));
    }

    public static <T> T deserializeItem(JsonParser p, Class<T> targetClass, Class<?> valueClass) throws IOException {
        TreeNode node = p.readValueAsTree();
        String fieldName = (String)node.fieldNames().next();
        try {
            return targetClass.getConstructor(String.class, valueClass).newInstance(fieldName, p.getCodec().treeToValue(node.get(fieldName), valueClass));
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
    }
}

