/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class URIDeserializer
extends JsonDeserializer<URI> {
    public URI deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        try {
            String uriStr = p.getValueAsString();
            if (uriStr == null) {
                throw new JsonMappingException((Closeable)p, "URI is not an string");
            }
            return new URI(uriStr);
        }
        catch (URISyntaxException ex) {
            throw new JsonMappingException((Closeable)p, ex.getMessage());
        }
    }
}

