/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.spi;

import io.serverlessworkflow.api.interfaces.WorkflowDiagram;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowDiagramProvider {
    private WorkflowDiagram workflowDiagram;
    private static Logger logger = LoggerFactory.getLogger(WorkflowDiagramProvider.class);

    public WorkflowDiagramProvider() {
        ServiceLoader<WorkflowDiagram> foundWorkflowDiagrams = ServiceLoader.load(WorkflowDiagram.class);
        Iterator<WorkflowDiagram> it = foundWorkflowDiagrams.iterator();
        if (it.hasNext()) {
            this.workflowDiagram = it.next();
            logger.info("Found workflow diagram: " + this.workflowDiagram.toString());
        }
    }

    public static WorkflowDiagramProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    public WorkflowDiagram get() {
        return this.workflowDiagram;
    }

    private static class LazyHolder {
        static final WorkflowDiagramProvider INSTANCE = new WorkflowDiagramProvider();

        private LazyHolder() {
        }
    }
}

