/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.common;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterManager<KEY, VALUE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterManager.class);
    private String name;
    private String registerErrorFmt = "Not allow regsiter repeat data, name=%s, key=%s";
    private Map<KEY, VALUE> objMap = new ConcurrentHashMap<KEY, VALUE>();
    private Object lockObj = new Object();

    public RegisterManager(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getRegisterErrorFmt() {
        return this.registerErrorFmt;
    }

    public void setRegisterErrorFmt(String registerErrorFmt) {
        this.registerErrorFmt = registerErrorFmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(KEY key, VALUE value) {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.objMap.get(key) != null) {
                String msg = String.format(this.registerErrorFmt, this.name, key);
                LOGGER.error(msg);
                throw new Error(msg);
            }
            this.objMap.put(key, value);
        }
    }

    public VALUE findValue(KEY key) {
        return this.objMap.get(key);
    }

    public VALUE ensureFindValue(KEY key) {
        VALUE value = this.objMap.get(key);
        if (value == null) {
            String msg = String.format("Can not find value, name=%s, key=%s", this.name, key);
            throw new Error(msg);
        }
        return value;
    }

    public Collection<KEY> keys() {
        return this.objMap.keySet();
    }

    public Collection<VALUE> values() {
        return this.objMap.values();
    }
}

