/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.common.utils;

import org.springframework.aop.TargetClassAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class BeanUtils {
    public static final String DEFAULT_BEAN_RESOURCE = "classpath*:META-INF/spring/*.bean.xml";
    private static ApplicationContext context;

    private BeanUtils() {
    }

    public static void init() {
        BeanUtils.init(DEFAULT_BEAN_RESOURCE);
    }

    public static void init(String ... configLocations) {
        context = new ClassPathXmlApplicationContext(configLocations);
    }

    public static ApplicationContext getContext() {
        return context;
    }

    public static void setContext(ApplicationContext applicationContext) {
        context = applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)context.getBean(name);
    }

    public static Class<?> getImplClassFromBean(Object bean) {
        if (TargetClassAware.class.isInstance(bean)) {
            return ((TargetClassAware)bean).getTargetClass();
        }
        return bean.getClass();
    }
}

