/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.netty;

import io.netty.buffer.ByteBufAllocator;
import io.servicetalk.buffer.netty.UnreleasableUnsafeDirectByteBuf;
import io.servicetalk.utils.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class UnreleasableUnsafeNoZeroingDirectByteBuf
extends UnreleasableUnsafeDirectByteBuf {
    UnreleasableUnsafeNoZeroingDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(alloc, initialCapacity, maxCapacity);
    }

    @Override
    protected ByteBuffer allocateDirect(int initialCapacity) {
        long memoryAddress;
        long size = Math.max(1, initialCapacity);
        PlatformDependent.reserveMemory(size, initialCapacity);
        try {
            memoryAddress = PlatformDependent.allocateMemory(size);
        }
        catch (Throwable e) {
            PlatformDependent.unreserveMemory(size, initialCapacity);
            return (ByteBuffer)PlatformDependent.throwException(e);
        }
        try {
            return PlatformDependent.newDirectBuffer(memoryAddress, size, initialCapacity);
        }
        catch (Throwable e) {
            PlatformDependent.freeMemory(memoryAddress);
            PlatformDependent.unreserveMemory(size, initialCapacity);
            return (ByteBuffer)PlatformDependent.throwException(e);
        }
    }
}

