/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.ProcessorSignalsConsumer;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

abstract class AbstractProcessorBuffer {
    private static final AtomicReferenceFieldUpdater<AbstractProcessorBuffer, TerminalNotification> terminalUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractProcessorBuffer.class, TerminalNotification.class, "terminal");
    @Nullable
    private volatile TerminalNotification terminal;

    AbstractProcessorBuffer() {
    }

    final boolean tryTerminate(TerminalNotification notification) {
        return terminalUpdater.compareAndSet(this, null, notification);
    }

    static boolean consumeIfTerminal(ProcessorSignalsConsumer<?> consumer, @Nullable Object signal) {
        if (signal instanceof TerminalNotification) {
            Throwable cause = ((TerminalNotification)signal).cause();
            if (cause != null) {
                consumer.consumeTerminal(cause);
            } else {
                consumer.consumeTerminal();
            }
            return true;
        }
        return false;
    }

    static <T> boolean consumeNextItem(ProcessorSignalsConsumer<T> consumer, @Nullable Object nextItem) {
        if (nextItem == null) {
            return false;
        }
        consumer.consumeItem(SubscriberApiUtils.unwrapNullUnchecked(nextItem));
        return true;
    }
}

