/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingle;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.ThreadInterruptingCancellable;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CallableSingle<T>
extends AbstractSynchronousSingle<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallableSingle.class);
    private final Callable<T> callable;

    CallableSingle(Callable<T> callable) {
        this.callable = Objects.requireNonNull(callable);
    }

    @Override
    void doSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        ThreadInterruptingCancellable cancellable = new ThreadInterruptingCancellable(Thread.currentThread());
        try {
            subscriber.onSubscribe(cancellable);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        try {
            T value = this.callable.call();
            try {
                cancellable.setDone();
                subscriber.onSuccess(value);
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from onSuccess of Subscriber {}.", (Object)subscriber, (Object)t);
            }
        }
        catch (Throwable t) {
            cancellable.setDone(t);
            subscriber.onError(t);
        }
    }
}

