/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import java.util.Objects;
import java.util.function.BiFunction;

final class ContextPreservingBiFunction<T, U, V>
implements BiFunction<T, U, V> {
    private final AsyncContextMap saved;
    private final BiFunction<T, U, V> delegate;

    ContextPreservingBiFunction(BiFunction<T, U, V> delegate, AsyncContextMap contextMap) {
        this.saved = Objects.requireNonNull(contextMap);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V apply(T t, U u) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                V v = this.delegate.apply(t, u);
                return v;
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        }
        return this.slowPath(t, u);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V slowPath(T t, U u) {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            V v = this.delegate.apply(t, u);
            return v;
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }
}

