/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

final class CopyOnWriteAsyncContextMap
implements AsyncContextMap {
    private static final AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater = AtomicReferenceFieldUpdater.newUpdater(CopyOnWriteAsyncContextMap.class, CopyAsyncContextMap.class, "map");
    private volatile CopyAsyncContextMap map;

    CopyOnWriteAsyncContextMap() {
        this(EmptyAsyncContextMap.INSTANCE);
    }

    private CopyOnWriteAsyncContextMap(CopyAsyncContextMap map) {
        this.map = map;
    }

    @Override
    @Nullable
    public <T> T get(AsyncContextMap.Key<T> key) {
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(AsyncContextMap.Key<?> key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    @Nullable
    public <T> T put(AsyncContextMap.Key<T> key, T value) {
        return this.map.put(key, value, this, mapUpdater);
    }

    @Override
    public void putAll(Map<AsyncContextMap.Key<?>, Object> map) {
        CopyAsyncContextMap contextMap;
        while (!mapUpdater.compareAndSet(this, contextMap = this.map, contextMap.putAll(map))) {
        }
    }

    @Override
    @Nullable
    public <T> T remove(AsyncContextMap.Key<T> key) {
        return this.map.remove(key, this, mapUpdater);
    }

    @Override
    public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries) {
        return this.map.removeAll(entries, this, mapUpdater);
    }

    @Override
    public void clear() {
        this.map = EmptyAsyncContextMap.INSTANCE;
    }

    @Override
    @Nullable
    public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
        return this.map.forEach(consumer);
    }

    @Override
    public AsyncContextMap copy() {
        return new CopyOnWriteAsyncContextMap(this.map);
    }

    public String toString() {
        return AsyncContextMapUtils.contextMapToString(this);
    }

    private static final class MutableInt {
        int value;

        private MutableInt() {
        }
    }

    static abstract class AbstractPutSevenBuilder
    implements BiPredicate<AsyncContextMap.Key<?>, Object>,
    BiConsumer<AsyncContextMap.Key<?>, Object> {
        Object[] pairs;
        int nextIndex;

        AbstractPutSevenBuilder(int arraySize, int nextIndex) {
            this.pairs = new Object[arraySize];
            this.nextIndex = nextIndex;
        }

        @Override
        public final void accept(AsyncContextMap.Key<?> key, Object o) {
            this.test(key, o);
        }

        @Override
        public final boolean test(AsyncContextMap.Key<?> key, Object o) {
            for (int i = 0; i < this.nextIndex; i += 2) {
                if (!this.pairs[i].equals(key)) continue;
                this.pairs[i + 1] = o;
                return false;
            }
            assert (this.nextIndex <= this.pairs.length - 2);
            this.pairs[this.nextIndex] = key;
            this.pairs[this.nextIndex + 1] = o;
            this.nextIndex += 2;
            return true;
        }
    }

    private static final class SevenOrMoreAsyncContextMap
    implements CopyAsyncContextMap {
        private final Object[] context;

        SevenOrMoreAsyncContextMap(Object ... context) {
            this.context = context;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.context.length >>> 1;
        }

        @Override
        public <T> T get(AsyncContextMap.Key<T> key) {
            int i = this.findIndex(key);
            return (T)(i < 0 ? null : this.context[i + 1]);
        }

        @Override
        public boolean containsKey(AsyncContextMap.Key<?> key) {
            return this.findIndex(key) >= 0;
        }

        @Override
        @Nullable
        public <T> T put(AsyncContextMap.Key<T> key, @Nullable T value, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            Object[] context;
            int i = this.findIndex(Objects.requireNonNull(key));
            if (i < 0) {
                context = new Object[this.context.length + 2];
                System.arraycopy(this.context, 0, context, 0, this.context.length);
                context[this.context.length] = key;
                context[this.context.length + 1] = value;
            } else {
                context = new Object[this.context.length];
                System.arraycopy(this.context, 0, context, 0, i + 1);
                context[i + 1] = value;
                if (i + 2 < context.length) {
                    System.arraycopy(this.context, i + 2, context, i + 2, context.length - i - 2);
                }
            }
            return (T)(mapUpdater.compareAndSet(owner, this, new SevenOrMoreAsyncContextMap(context)) ? this.context[i + 1] : null);
        }

        @Override
        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> map) {
            PutAllConsumer consumer = new PutAllConsumer(map.size());
            map.forEach(consumer);
            Object[] context = new Object[this.context.length + (consumer.newItems << 1)];
            System.arraycopy(this.context, 0, context, 0, this.context.length);
            PutAllPopulateConsumer populateConsumer = new PutAllPopulateConsumer(consumer.keyIndexes, this.context, context);
            map.forEach(populateConsumer);
            return new SevenOrMoreAsyncContextMap(context);
        }

        @Override
        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> key, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            int i = this.findIndex(key);
            if (i < 0) {
                return null;
            }
            if (this.size() == 7) {
                return (T)(mapUpdater.compareAndSet(owner, this, this.removeBelowSeven(i)) ? this.context[i + 1] : owner.remove(key));
            }
            Object[] context = new Object[this.context.length - 2];
            System.arraycopy(this.context, 0, context, 0, i);
            System.arraycopy(this.context, i + 2, context, i, this.context.length - i - 2);
            return (T)(mapUpdater.compareAndSet(owner, this, new SevenOrMoreAsyncContextMap(context)) ? this.context[i + 1] : owner.remove(key));
        }

        @Override
        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            GrowableIntArray indexesToRemove = new GrowableIntArray(3);
            entries.forEach((? super T key) -> {
                int keyIndex = this.findIndex((AsyncContextMap.Key<?>)key);
                if (keyIndex >= 0) {
                    indexesToRemove.add(keyIndex);
                }
            });
            CopyAsyncContextMap newMap = this.removeAll(indexesToRemove);
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(entries);
        }

        private int findIndex(AsyncContextMap.Key<?> key) {
            for (int i = 0; i < this.context.length; i += 2) {
                if (!key.equals(this.context[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
            for (int i = 0; i < this.context.length; i += 2) {
                AsyncContextMap.Key key = (AsyncContextMap.Key)this.context[i];
                if (consumer.test(key, this.context[i + 1])) continue;
                return key;
            }
            return null;
        }

        @Nullable
        private CopyAsyncContextMap removeAll(GrowableIntArray indexesToRemove) {
            if (this.size() == indexesToRemove.size) {
                return EmptyAsyncContextMap.INSTANCE;
            }
            if (indexesToRemove.size == 0) {
                return null;
            }
            if (this.size() - indexesToRemove.size < 7) {
                return this.removeBelowSeven(indexesToRemove);
            }
            Object[] context = new Object[this.context.length - (indexesToRemove.size << 1)];
            int newContextIndex = 0;
            for (int i = 0; i < this.context.length; i += 2) {
                if (!indexesToRemove.isValueAbsent(i)) continue;
                context[newContextIndex] = this.context[i];
                context[newContextIndex + 1] = this.context[i + 1];
                newContextIndex += 2;
            }
            return new SevenOrMoreAsyncContextMap(context);
        }

        private CopyAsyncContextMap removeBelowSeven(int i) {
            switch (i) {
                case 0: {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.context[2], this.context[3], (AsyncContextMap.Key)this.context[4], this.context[5], (AsyncContextMap.Key)this.context[6], this.context[7], (AsyncContextMap.Key)this.context[8], this.context[9], (AsyncContextMap.Key)this.context[10], this.context[11], (AsyncContextMap.Key)this.context[12], this.context[13]);
                }
                case 2: {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.context[0], this.context[1], (AsyncContextMap.Key)this.context[4], this.context[5], (AsyncContextMap.Key)this.context[6], this.context[7], (AsyncContextMap.Key)this.context[8], this.context[9], (AsyncContextMap.Key)this.context[10], this.context[11], (AsyncContextMap.Key)this.context[12], this.context[13]);
                }
                case 4: {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.context[0], this.context[1], (AsyncContextMap.Key)this.context[2], this.context[3], (AsyncContextMap.Key)this.context[6], this.context[7], (AsyncContextMap.Key)this.context[8], this.context[9], (AsyncContextMap.Key)this.context[10], this.context[11], (AsyncContextMap.Key)this.context[12], this.context[13]);
                }
                case 6: {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.context[0], this.context[1], (AsyncContextMap.Key)this.context[2], this.context[3], (AsyncContextMap.Key)this.context[4], this.context[5], (AsyncContextMap.Key)this.context[8], this.context[9], (AsyncContextMap.Key)this.context[10], this.context[11], (AsyncContextMap.Key)this.context[12], this.context[13]);
                }
                case 8: {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.context[0], this.context[1], (AsyncContextMap.Key)this.context[2], this.context[3], (AsyncContextMap.Key)this.context[4], this.context[5], (AsyncContextMap.Key)this.context[6], this.context[7], (AsyncContextMap.Key)this.context[10], this.context[11], (AsyncContextMap.Key)this.context[12], this.context[13]);
                }
                case 10: {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.context[0], this.context[1], (AsyncContextMap.Key)this.context[2], this.context[3], (AsyncContextMap.Key)this.context[4], this.context[5], (AsyncContextMap.Key)this.context[6], this.context[7], (AsyncContextMap.Key)this.context[8], this.context[9], (AsyncContextMap.Key)this.context[12], this.context[13]);
                }
                case 12: {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.context[0], this.context[1], (AsyncContextMap.Key)this.context[2], this.context[3], (AsyncContextMap.Key)this.context[4], this.context[5], (AsyncContextMap.Key)this.context[6], this.context[7], (AsyncContextMap.Key)this.context[8], this.context[9], (AsyncContextMap.Key)this.context[10], this.context[11]);
                }
            }
            throw new RuntimeException("programming error. unable to remove i: " + i);
        }

        private CopyAsyncContextMap removeBelowSeven(GrowableIntArray indexesToRemove) {
            switch (this.size() - indexesToRemove.size) {
                case 1: {
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        return new OneAsyncContextMap((AsyncContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 2: {
                    int keepI1 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        return new TwoAsyncContextMap((AsyncContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (AsyncContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 3: {
                    int keepI1 = -1;
                    int keepI2 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        if (keepI2 < 0) {
                            keepI2 = i;
                            continue;
                        }
                        return new ThreeAsyncContextMap((AsyncContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (AsyncContextMap.Key)this.context[keepI2], this.context[keepI2 + 1], (AsyncContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 4: {
                    int keepI1 = -1;
                    int keepI2 = -1;
                    int keepI3 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        if (keepI2 < 0) {
                            keepI2 = i;
                            continue;
                        }
                        if (keepI3 < 0) {
                            keepI3 = i;
                            continue;
                        }
                        return new FourAsyncContextMap((AsyncContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (AsyncContextMap.Key)this.context[keepI2], this.context[keepI2 + 1], (AsyncContextMap.Key)this.context[keepI3], this.context[keepI3 + 1], (AsyncContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 5: {
                    int keepI1 = -1;
                    int keepI2 = -1;
                    int keepI3 = -1;
                    int keepI4 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        if (keepI2 < 0) {
                            keepI2 = i;
                            continue;
                        }
                        if (keepI3 < 0) {
                            keepI3 = i;
                            continue;
                        }
                        if (keepI4 < 0) {
                            keepI4 = i;
                            continue;
                        }
                        return new FiveAsyncContextMap((AsyncContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (AsyncContextMap.Key)this.context[keepI2], this.context[keepI2 + 1], (AsyncContextMap.Key)this.context[keepI3], this.context[keepI3 + 1], (AsyncContextMap.Key)this.context[keepI4], this.context[keepI4 + 1], (AsyncContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 6: {
                    int keepI1 = -1;
                    int keepI2 = -1;
                    int keepI3 = -1;
                    int keepI4 = -1;
                    int keepI5 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        if (keepI2 < 0) {
                            keepI2 = i;
                            continue;
                        }
                        if (keepI3 < 0) {
                            keepI3 = i;
                            continue;
                        }
                        if (keepI4 < 0) {
                            keepI4 = i;
                            continue;
                        }
                        if (keepI5 < 0) {
                            keepI5 = i;
                            continue;
                        }
                        return new SixAsyncContextMap((AsyncContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (AsyncContextMap.Key)this.context[keepI2], this.context[keepI2 + 1], (AsyncContextMap.Key)this.context[keepI3], this.context[keepI3 + 1], (AsyncContextMap.Key)this.context[keepI4], this.context[keepI4 + 1], (AsyncContextMap.Key)this.context[keepI5], this.context[keepI5 + 1], (AsyncContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
            }
            throw new RuntimeException("programming error. unable to reduce: " + (this.size() - indexesToRemove.size));
        }

        private static final class PutAllPopulateConsumer
        implements BiConsumer<AsyncContextMap.Key<?>, Object> {
            private int i;
            private int newItemIndex;
            private final GrowableIntArray keyIndexes;
            private final Object[] newContext;

            PutAllPopulateConsumer(GrowableIntArray keyIndexes, Object[] oldContext, Object[] newContext) {
                this.keyIndexes = keyIndexes;
                this.newContext = newContext;
                this.newItemIndex = oldContext.length;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                int keyIndex;
                if ((keyIndex = this.keyIndexes.get(this.i++)) < 0) {
                    this.newContext[this.newItemIndex] = key;
                    this.newContext[this.newItemIndex + 1] = o;
                    this.newItemIndex += 2;
                } else {
                    this.newContext[keyIndex] = key;
                    this.newContext[keyIndex + 1] = o;
                }
            }
        }

        private final class PutAllConsumer
        implements BiConsumer<AsyncContextMap.Key<?>, Object> {
            int newItems;
            final GrowableIntArray keyIndexes;

            PutAllConsumer(int mapSize) {
                this.keyIndexes = new GrowableIntArray(mapSize);
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                int keyIndex = SevenOrMoreAsyncContextMap.this.findIndex(key);
                if (keyIndex < 0) {
                    ++this.newItems;
                }
                this.keyIndexes.add(keyIndex);
            }
        }

        private static final class GrowableIntArray {
            private int[] array;
            int size;

            GrowableIntArray(int size) {
                this.array = new int[size];
            }

            void add(int value) {
                if (this.size == this.array.length) {
                    int[] newArray = new int[this.array.length << 1];
                    System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                    this.array = newArray;
                }
                this.array[this.size++] = value;
            }

            int get(int i) {
                return this.array[i];
            }

            boolean isValueAbsent(int value) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.array[i] != value) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private static final class SixAsyncContextMap
    implements CopyAsyncContextMap,
    BiConsumer<AsyncContextMap.Key<?>, Object>,
    BiPredicate<AsyncContextMap.Key<?>, Object> {
        @Nullable
        private AsyncContextMap.Key<?> keyOne;
        @Nullable
        private Object valueOne;
        @Nullable
        private AsyncContextMap.Key<?> keyTwo;
        @Nullable
        private Object valueTwo;
        @Nullable
        private AsyncContextMap.Key<?> keyThree;
        @Nullable
        private Object valueThree;
        @Nullable
        private AsyncContextMap.Key<?> keyFour;
        @Nullable
        private Object valueFour;
        @Nullable
        private AsyncContextMap.Key<?> keyFive;
        @Nullable
        private Object valueFive;
        @Nullable
        private AsyncContextMap.Key<?> keySix;
        @Nullable
        private Object valueSix;

        SixAsyncContextMap() {
        }

        SixAsyncContextMap(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour, AsyncContextMap.Key<?> keyFive, @Nullable Object valueFive, AsyncContextMap.Key<?> keySix, @Nullable Object valueSix) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
            this.keyThree = keyThree;
            this.valueThree = valueThree;
            this.keyFour = keyFour;
            this.valueFour = valueFour;
            this.keyFive = keyFive;
            this.valueFive = valueFive;
            this.keySix = keySix;
            this.valueSix = valueSix;
        }

        @Override
        @Nullable
        public <T> T get(AsyncContextMap.Key<T> key) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null && this.keySix != null);
            return (T)(this.keyOne.equals(key) ? this.valueOne : (this.keyTwo.equals(key) ? this.valueTwo : (this.keyThree.equals(key) ? this.valueThree : (this.keyFour.equals(key) ? this.valueFour : (this.keyFive.equals(key) ? this.valueFive : (this.keySix.equals(key) ? this.valueSix : null))))));
        }

        @Override
        public boolean containsKey(AsyncContextMap.Key<?> key) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null && this.keySix != null);
            return this.keyOne.equals(key) || this.keyTwo.equals(key) || this.keyThree.equals(key) || this.keyFour.equals(key) || this.keyFive.equals(key) || this.keySix.equals(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 6;
        }

        @Override
        @Nullable
        public <T> T put(AsyncContextMap.Key<T> key, T value, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null && this.keySix != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixAsyncContextMap(this.keyOne, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueOne : owner.put(key, value));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueTwo : owner.put(key, value));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, value, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueThree : owner.put(key, value));
            }
            if (this.keyFour.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, value, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueFour : owner.put(key, value));
            }
            if (this.keyFive.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, value, this.keySix, this.valueSix)) ? this.valueFive : owner.put(key, value));
            }
            if (this.keySix.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, value)) ? this.valueSix : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new SevenOrMoreAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> map) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null && this.keySix != null);
            if (map.isEmpty()) {
                return this;
            }
            PutSevenBuilder builder = new PutSevenBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix, map.size());
            map.forEach(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> key, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null && this.keySix != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueOne : owner.remove(key));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueTwo : owner.remove(key));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueThree : owner.remove(key));
            }
            if (this.keyFour.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueFour : owner.remove(key));
            }
            if (this.keyFive.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix)) ? this.valueFive : owner.remove(key));
            }
            if (this.keySix.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueSix : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null && this.keySix != null);
            MutableInt removeIndexMask = new MutableInt();
            entries.forEach((? super T k) -> {
                if (this.keyOne.equals(k)) {
                    removeIndexMask.value |= 1;
                } else if (this.keyTwo.equals(k)) {
                    removeIndexMask.value |= 2;
                } else if (this.keyThree.equals(k)) {
                    removeIndexMask.value |= 4;
                } else if (this.keyFour.equals(k)) {
                    removeIndexMask.value |= 8;
                } else if (this.keyFive.equals(k)) {
                    removeIndexMask.value |= 0x10;
                } else if (this.keySix.equals(k)) {
                    removeIndexMask.value |= 0x20;
                }
            });
            CopyAsyncContextMap newMap = this.removeAll(removeIndexMask);
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(entries);
        }

        @Nullable
        private CopyAsyncContextMap removeAll(MutableInt removeIndexMask) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null && this.keySix != null);
            if ((removeIndexMask.value & 0x3F) == 63) {
                return EmptyAsyncContextMap.INSTANCE;
            }
            if ((removeIndexMask.value & 0x20) == 32) {
                if ((removeIndexMask.value & 0x10) == 16) {
                    if ((removeIndexMask.value & 8) == 8) {
                        if ((removeIndexMask.value & 4) == 4) {
                            if ((removeIndexMask.value & 2) == 2) {
                                return new OneAsyncContextMap(this.keyOne, this.valueOne);
                            }
                            if ((removeIndexMask.value & 1) == 1) {
                                return new OneAsyncContextMap(this.keyTwo, this.valueTwo);
                            }
                            return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                        }
                        if ((removeIndexMask.value & 2) == 2) {
                            if ((removeIndexMask.value & 1) == 1) {
                                return new OneAsyncContextMap(this.keyThree, this.valueThree);
                            }
                            return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree);
                        }
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                    }
                    if ((removeIndexMask.value & 4) == 4) {
                        if ((removeIndexMask.value & 2) == 2) {
                            if ((removeIndexMask.value & 1) == 1) {
                                return new OneAsyncContextMap(this.keyFour, this.valueFour);
                            }
                            return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour);
                        }
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                    }
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                if ((removeIndexMask.value & 8) == 8) {
                    if ((removeIndexMask.value & 4) == 4) {
                        if ((removeIndexMask.value & 2) == 2) {
                            if ((removeIndexMask.value & 1) == 1) {
                                return new OneAsyncContextMap(this.keyFive, this.valueFive);
                            }
                            return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyFive, this.valueFive);
                        }
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFive, this.valueFive);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFive, this.valueFive);
                    }
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask.value & 4) == 4) {
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new FourAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
            if ((removeIndexMask.value & 0x10) == 16) {
                if ((removeIndexMask.value & 8) == 8) {
                    if ((removeIndexMask.value & 4) == 4) {
                        if ((removeIndexMask.value & 2) == 2) {
                            if ((removeIndexMask.value & 1) == 1) {
                                return new OneAsyncContextMap(this.keySix, this.valueSix);
                            }
                            return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keySix, this.valueSix);
                        }
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keySix, this.valueSix);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keySix, this.valueSix);
                    }
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyThree, this.valueThree, this.keySix, this.valueSix);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keySix, this.valueSix);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keySix, this.valueSix);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keySix, this.valueSix);
                }
                if ((removeIndexMask.value & 4) == 4) {
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyFour, this.valueFour, this.keySix, this.valueSix);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                }
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new FourAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix);
            }
            if ((removeIndexMask.value & 8) == 8) {
                if ((removeIndexMask.value & 4) == 4) {
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new TwoAsyncContextMap(this.keyFive, this.valueFive, this.keySix, this.valueSix);
                        }
                        return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new FourAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
            if ((removeIndexMask.value & 4) == 4) {
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new ThreeAsyncContextMap(this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                    }
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new FourAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
            if ((removeIndexMask.value & 2) == 2) {
                if ((removeIndexMask.value & 1) == 1) {
                    return new FourAsyncContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
            if ((removeIndexMask.value & 1) == 1) {
                return new FiveAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
            return null;
        }

        @Override
        @Nullable
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            if (!consumer.test(this.keyTwo, this.valueTwo)) {
                return this.keyTwo;
            }
            if (!consumer.test(this.keyThree, this.valueThree)) {
                return this.keyThree;
            }
            if (!consumer.test(this.keyFour, this.valueFour)) {
                return this.keyFour;
            }
            if (!consumer.test(this.keyFive, this.valueFive)) {
                return this.keyFive;
            }
            return consumer.test(this.keySix, this.valueSix) ? null : this.keySix;
        }

        @Override
        public void accept(AsyncContextMap.Key<?> key, Object value) {
            this.test(key, value);
        }

        @Override
        public boolean test(AsyncContextMap.Key<?> key, Object value) {
            if (this.keyOne == null) {
                this.keyOne = key;
                this.valueOne = value;
            } else if (this.keyTwo == null) {
                this.keyTwo = key;
                this.valueTwo = value;
            } else if (this.keyThree == null) {
                this.keyThree = key;
                this.valueThree = value;
            } else if (this.keyFour == null) {
                this.keyFour = key;
                this.valueFour = value;
            } else if (this.keyFive == null) {
                this.keyFive = key;
                this.valueFive = value;
            } else {
                assert (this.keySix == null);
                this.keySix = key;
                this.valueSix = value;
                return false;
            }
            return true;
        }

        private static final class PutSevenBuilder
        extends AbstractPutSevenBuilder {
            PutSevenBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour, AsyncContextMap.Key<?> keyFive, @Nullable Object valueFive, AsyncContextMap.Key<?> keySix, @Nullable Object valueSix, int putAllMapSize) {
                super(6 + putAllMapSize << 1, 12);
                this.pairs[0] = keyOne;
                this.pairs[1] = valueOne;
                this.pairs[2] = keyTwo;
                this.pairs[3] = valueTwo;
                this.pairs[4] = keyThree;
                this.pairs[5] = valueThree;
                this.pairs[6] = keyFour;
                this.pairs[7] = valueFour;
                this.pairs[8] = keyFive;
                this.pairs[9] = valueFive;
                this.pairs[10] = keySix;
                this.pairs[11] = valueSix;
            }

            CopyAsyncContextMap build() {
                if (this.nextIndex == 12) {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9], (AsyncContextMap.Key)this.pairs[10], this.pairs[11]);
                }
                if (this.nextIndex == this.pairs.length) {
                    return new SevenOrMoreAsyncContextMap(this.pairs);
                }
                return new SevenOrMoreAsyncContextMap(Arrays.copyOf(this.pairs, this.nextIndex));
            }
        }
    }

    private static final class FiveAsyncContextMap
    implements CopyAsyncContextMap,
    BiConsumer<AsyncContextMap.Key<?>, Object>,
    BiPredicate<AsyncContextMap.Key<?>, Object> {
        @Nullable
        private AsyncContextMap.Key<?> keyOne;
        @Nullable
        private Object valueOne;
        @Nullable
        private AsyncContextMap.Key<?> keyTwo;
        @Nullable
        private Object valueTwo;
        @Nullable
        private AsyncContextMap.Key<?> keyThree;
        @Nullable
        private Object valueThree;
        @Nullable
        private AsyncContextMap.Key<?> keyFour;
        @Nullable
        private Object valueFour;
        @Nullable
        private AsyncContextMap.Key<?> keyFive;
        @Nullable
        private Object valueFive;

        FiveAsyncContextMap() {
        }

        FiveAsyncContextMap(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour, AsyncContextMap.Key<?> keyFive, @Nullable Object valueFive) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
            this.keyThree = keyThree;
            this.valueThree = valueThree;
            this.keyFour = keyFour;
            this.valueFour = valueFour;
            this.keyFive = keyFive;
            this.valueFive = valueFive;
        }

        @Override
        @Nullable
        public <T> T get(AsyncContextMap.Key<T> key) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null);
            return (T)(this.keyOne.equals(key) ? this.valueOne : (this.keyTwo.equals(key) ? this.valueTwo : (this.keyThree.equals(key) ? this.valueThree : (this.keyFour.equals(key) ? this.valueFour : (this.keyFive.equals(key) ? this.valueFive : null)))));
        }

        @Override
        public boolean containsKey(AsyncContextMap.Key<?> key) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null);
            return this.keyOne.equals(key) || this.keyTwo.equals(key) || this.keyThree.equals(key) || this.keyFour.equals(key) || this.keyFive.equals(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 5;
        }

        @Override
        @Nullable
        public <T> T put(AsyncContextMap.Key<T> key, T value, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueOne : owner.put(key, value));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueTwo : owner.put(key, value));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, value, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueThree : owner.put(key, value));
            }
            if (this.keyFour.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, value, this.keyFive, this.valueFive)) ? this.valueFour : owner.put(key, value));
            }
            if (this.keyFive.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, value)) ? this.valueFive : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> map) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null);
            switch (map.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    PutSixBuilder builder = new PutSixBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    map.forEach(builder);
                    return builder.build();
                }
            }
            PutSevenBuilder builder = new PutSevenBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, map.size());
            map.forEach(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> key, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueOne : owner.remove(key));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueTwo : owner.remove(key));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueThree : owner.remove(key));
            }
            if (this.keyFour.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive)) ? this.valueFour : owner.remove(key));
            }
            if (this.keyFive.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueFive : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null);
            MutableInt removeIndexMask = new MutableInt();
            entries.forEach((? super T k) -> {
                if (this.keyOne.equals(k)) {
                    removeIndexMask.value |= 1;
                } else if (this.keyTwo.equals(k)) {
                    removeIndexMask.value |= 2;
                } else if (this.keyThree.equals(k)) {
                    removeIndexMask.value |= 4;
                } else if (this.keyFour.equals(k)) {
                    removeIndexMask.value |= 8;
                } else if (this.keyFive.equals(k)) {
                    removeIndexMask.value |= 0x10;
                }
            });
            CopyAsyncContextMap newMap = this.removeAll(removeIndexMask);
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(entries);
        }

        @Nullable
        private CopyAsyncContextMap removeAll(MutableInt removeIndexMask) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null);
            if ((removeIndexMask.value & 0x1F) == 31) {
                return EmptyAsyncContextMap.INSTANCE;
            }
            if ((removeIndexMask.value & 0x10) == 16) {
                if ((removeIndexMask.value & 8) == 8) {
                    if ((removeIndexMask.value & 4) == 4) {
                        if ((removeIndexMask.value & 2) == 2) {
                            return new OneAsyncContextMap(this.keyOne, this.valueOne);
                        }
                        if ((removeIndexMask.value & 1) == 1) {
                            return new OneAsyncContextMap(this.keyTwo, this.valueTwo);
                        }
                        return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                    }
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new OneAsyncContextMap(this.keyThree, this.valueThree);
                        }
                        return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                    }
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                if ((removeIndexMask.value & 4) == 4) {
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new OneAsyncContextMap(this.keyFour, this.valueFour);
                        }
                        return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                    }
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                }
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new TwoAsyncContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                    }
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }
            if ((removeIndexMask.value & 8) == 8) {
                if ((removeIndexMask.value & 4) == 4) {
                    if ((removeIndexMask.value & 2) == 2) {
                        if ((removeIndexMask.value & 1) == 1) {
                            return new OneAsyncContextMap(this.keyFive, this.valueFive);
                        }
                        return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyFive, this.valueFive);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFive, this.valueFive);
                    }
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new TwoAsyncContextMap(this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                    }
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                }
                return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
            }
            if ((removeIndexMask.value & 4) == 4) {
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new TwoAsyncContextMap(this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    }
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
            if ((removeIndexMask.value & 2) == 2) {
                if ((removeIndexMask.value & 1) == 1) {
                    return new ThreeAsyncContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
            if ((removeIndexMask.value & 1) == 1) {
                return new FourAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
            return null;
        }

        @Override
        @Nullable
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            if (!consumer.test(this.keyTwo, this.valueTwo)) {
                return this.keyTwo;
            }
            if (!consumer.test(this.keyThree, this.valueThree)) {
                return this.keyThree;
            }
            if (!consumer.test(this.keyFour, this.valueFour)) {
                return this.keyFour;
            }
            return consumer.test(this.keyFive, this.valueFive) ? null : this.keyFive;
        }

        @Override
        public void accept(AsyncContextMap.Key<?> key, Object value) {
            this.test(key, value);
        }

        @Override
        public boolean test(AsyncContextMap.Key<?> key, Object value) {
            if (this.keyOne == null) {
                this.keyOne = key;
                this.valueOne = value;
            } else if (this.keyTwo == null) {
                this.keyTwo = key;
                this.valueTwo = value;
            } else if (this.keyThree == null) {
                this.keyThree = key;
                this.valueThree = value;
            } else if (this.keyFour == null) {
                this.keyFour = key;
                this.valueFour = value;
            } else {
                assert (this.keyFive == null);
                this.keyFive = key;
                this.valueFive = value;
                return false;
            }
            return true;
        }

        private static final class PutSevenBuilder
        extends AbstractPutSevenBuilder {
            PutSevenBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour, AsyncContextMap.Key<?> keyFive, @Nullable Object valueFive, int putAllMapSize) {
                super(5 + putAllMapSize << 1, 10);
                this.pairs[0] = keyOne;
                this.pairs[1] = valueOne;
                this.pairs[2] = keyTwo;
                this.pairs[3] = valueTwo;
                this.pairs[4] = keyThree;
                this.pairs[5] = valueThree;
                this.pairs[6] = keyFour;
                this.pairs[7] = valueFour;
                this.pairs[8] = keyFive;
                this.pairs[9] = valueFive;
            }

            CopyAsyncContextMap build() {
                if (this.nextIndex == 10) {
                    return new FiveAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9]);
                }
                if (this.nextIndex == 12) {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9], (AsyncContextMap.Key)this.pairs[10], this.pairs[11]);
                }
                if (this.nextIndex == this.pairs.length) {
                    return new SevenOrMoreAsyncContextMap(this.pairs);
                }
                return new SevenOrMoreAsyncContextMap(Arrays.copyOf(this.pairs, this.nextIndex));
            }
        }

        private static final class PutSixBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            private final AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            private final AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            private final AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;
            @Nullable
            private AsyncContextMap.Key<?> keySix;
            @Nullable
            private Object valueSix;

            PutSixBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour, AsyncContextMap.Key<?> keyFive, @Nullable Object valueFive) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
                this.keyThree = keyThree;
                this.valueThree = valueThree;
                this.keyFour = keyFour;
                this.valueFour = valueFour;
                this.keyFive = keyFive;
                this.valueFive = valueFive;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree.equals(key)) {
                    this.valueThree = o;
                } else if (this.keyFour.equals(key)) {
                    this.valueFour = o;
                } else if (this.keyFive.equals(key)) {
                    this.valueFive = o;
                } else {
                    assert (this.keySix == null);
                    this.keySix = key;
                    this.valueSix = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                if (this.keySix == null) {
                    return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
        }
    }

    private static final class FourAsyncContextMap
    implements CopyAsyncContextMap,
    BiConsumer<AsyncContextMap.Key<?>, Object>,
    BiPredicate<AsyncContextMap.Key<?>, Object> {
        @Nullable
        private AsyncContextMap.Key<?> keyOne;
        @Nullable
        private Object valueOne;
        @Nullable
        private AsyncContextMap.Key<?> keyTwo;
        @Nullable
        private Object valueTwo;
        @Nullable
        private AsyncContextMap.Key<?> keyThree;
        @Nullable
        private Object valueThree;
        @Nullable
        private AsyncContextMap.Key<?> keyFour;
        @Nullable
        private Object valueFour;

        FourAsyncContextMap() {
        }

        FourAsyncContextMap(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
            this.keyThree = keyThree;
            this.valueThree = valueThree;
            this.keyFour = keyFour;
            this.valueFour = valueFour;
        }

        @Override
        @Nullable
        public <T> T get(AsyncContextMap.Key<T> key) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null);
            return (T)(this.keyOne.equals(key) ? this.valueOne : (this.keyTwo.equals(key) ? this.valueTwo : (this.keyThree.equals(key) ? this.valueThree : (this.keyFour.equals(key) ? this.valueFour : null))));
        }

        @Override
        public boolean containsKey(AsyncContextMap.Key<?> key) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null);
            return this.keyOne.equals(key) || this.keyTwo.equals(key) || this.keyThree.equals(key) || this.keyFour.equals(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        @Nullable
        public <T> T put(AsyncContextMap.Key<T> key, T value, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueOne : owner.put(key, value));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueTwo : owner.put(key, value));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, value, this.keyFour, this.valueFour)) ? this.valueThree : owner.put(key, value));
            }
            if (this.keyFour.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, value)) ? this.valueFour : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> map) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null);
            switch (map.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    PutFiveBuilder builder = new PutFiveBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                    map.forEach(builder);
                    return builder.build();
                }
                case 2: {
                    PutSixBuilder builder = new PutSixBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                    map.forEach(builder);
                    return builder.build();
                }
            }
            PutSevenBuilder builder = new PutSevenBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, map.size());
            map.forEach(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> key, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueOne : owner.remove(key));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueTwo : owner.remove(key));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour)) ? this.valueThree : owner.remove(key));
            }
            if (this.keyFour.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree)) ? this.valueFour : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null);
            MutableInt removeIndexMask = new MutableInt();
            entries.forEach((? super T k) -> {
                if (this.keyOne.equals(k)) {
                    removeIndexMask.value |= 1;
                } else if (this.keyTwo.equals(k)) {
                    removeIndexMask.value |= 2;
                } else if (this.keyThree.equals(k)) {
                    removeIndexMask.value |= 4;
                } else if (this.keyFour.equals(k)) {
                    removeIndexMask.value |= 8;
                }
            });
            CopyAsyncContextMap newMap = this.removeAll(removeIndexMask);
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(entries);
        }

        @Nullable
        private CopyAsyncContextMap removeAll(MutableInt removeIndexMask) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null && this.keyFour != null);
            if ((removeIndexMask.value & 0xF) == 15) {
                return EmptyAsyncContextMap.INSTANCE;
            }
            if ((removeIndexMask.value & 8) == 8) {
                if ((removeIndexMask.value & 4) == 4) {
                    if ((removeIndexMask.value & 2) == 2) {
                        return new OneAsyncContextMap(this.keyOne, this.valueOne);
                    }
                    if ((removeIndexMask.value & 1) == 1) {
                        return new OneAsyncContextMap(this.keyTwo, this.valueTwo);
                    }
                    return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                }
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new OneAsyncContextMap(this.keyThree, this.valueThree);
                    }
                    return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
            }
            if ((removeIndexMask.value & 4) == 4) {
                if ((removeIndexMask.value & 2) == 2) {
                    if ((removeIndexMask.value & 1) == 1) {
                        return new OneAsyncContextMap(this.keyFour, this.valueFour);
                    }
                    return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                }
                return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
            }
            if ((removeIndexMask.value & 2) == 2) {
                if ((removeIndexMask.value & 1) == 1) {
                    return new TwoAsyncContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }
            if ((removeIndexMask.value & 1) == 1) {
                return new ThreeAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }
            return null;
        }

        @Override
        @Nullable
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            if (!consumer.test(this.keyTwo, this.valueTwo)) {
                return this.keyTwo;
            }
            if (!consumer.test(this.keyThree, this.valueThree)) {
                return this.keyThree;
            }
            return consumer.test(this.keyFour, this.valueFour) ? null : this.keyFour;
        }

        @Override
        public void accept(AsyncContextMap.Key<?> key, Object value) {
            this.test(key, value);
        }

        @Override
        public boolean test(AsyncContextMap.Key<?> key, Object value) {
            if (this.keyOne == null) {
                this.keyOne = key;
                this.valueOne = value;
            } else if (this.keyTwo == null) {
                this.keyTwo = key;
                this.valueTwo = value;
            } else if (this.keyThree == null) {
                this.keyThree = key;
                this.valueThree = value;
            } else {
                assert (this.keyFour == null);
                this.keyFour = key;
                this.valueFour = value;
                return false;
            }
            return true;
        }

        private static final class PutSevenBuilder
        extends AbstractPutSevenBuilder {
            PutSevenBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour, int putAllMapSize) {
                super(4 + putAllMapSize << 1, 8);
                this.pairs[0] = keyOne;
                this.pairs[1] = valueOne;
                this.pairs[2] = keyTwo;
                this.pairs[3] = valueTwo;
                this.pairs[4] = keyThree;
                this.pairs[5] = valueThree;
                this.pairs[6] = keyFour;
                this.pairs[7] = valueFour;
            }

            CopyAsyncContextMap build() {
                if (this.nextIndex == 8) {
                    return new FourAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7]);
                }
                if (this.nextIndex == 10) {
                    return new FiveAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9]);
                }
                if (this.nextIndex == 12) {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9], (AsyncContextMap.Key)this.pairs[10], this.pairs[11]);
                }
                if (this.nextIndex == this.pairs.length) {
                    return new SevenOrMoreAsyncContextMap(this.pairs);
                }
                return new SevenOrMoreAsyncContextMap(Arrays.copyOf(this.pairs, this.nextIndex));
            }
        }

        private static final class PutSixBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            private final AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            private final AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            @Nullable
            private AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;
            @Nullable
            private AsyncContextMap.Key<?> keySix;
            @Nullable
            private Object valueSix;

            PutSixBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
                this.keyThree = keyThree;
                this.valueThree = valueThree;
                this.keyFour = keyFour;
                this.valueFour = valueFour;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree.equals(key)) {
                    this.valueThree = o;
                } else if (this.keyFour.equals(key)) {
                    this.valueFour = o;
                } else if (this.keyFive == null) {
                    this.keyFive = key;
                    this.valueFive = o;
                } else {
                    assert (this.keySix == null);
                    this.keySix = key;
                    this.valueSix = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                if (this.keyFive == null) {
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                if (this.keySix == null) {
                    return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
        }

        private static final class PutFiveBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            private final AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            private final AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            @Nullable
            private AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;

            PutFiveBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, AsyncContextMap.Key<?> keyFour, @Nullable Object valueFour) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
                this.keyThree = keyThree;
                this.valueThree = valueThree;
                this.keyFour = keyFour;
                this.valueFour = valueFour;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree.equals(key)) {
                    this.valueThree = o;
                } else if (this.keyFour.equals(key)) {
                    this.valueFour = o;
                } else {
                    assert (this.keyFive == null);
                    this.keyFive = key;
                    this.valueFive = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                if (this.keyFive == null) {
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
        }
    }

    private static final class ThreeAsyncContextMap
    implements CopyAsyncContextMap,
    BiConsumer<AsyncContextMap.Key<?>, Object>,
    BiPredicate<AsyncContextMap.Key<?>, Object> {
        @Nullable
        private AsyncContextMap.Key<?> keyOne;
        @Nullable
        private Object valueOne;
        @Nullable
        private AsyncContextMap.Key<?> keyTwo;
        @Nullable
        private Object valueTwo;
        @Nullable
        private AsyncContextMap.Key<?> keyThree;
        @Nullable
        private Object valueThree;

        ThreeAsyncContextMap() {
        }

        ThreeAsyncContextMap(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
            this.keyThree = keyThree;
            this.valueThree = valueThree;
        }

        @Override
        @Nullable
        public <T> T get(AsyncContextMap.Key<T> key) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null);
            return (T)(this.keyOne.equals(key) ? this.valueOne : (this.keyTwo.equals(key) ? this.valueTwo : (this.keyThree.equals(key) ? this.valueThree : null)));
        }

        @Override
        public boolean containsKey(AsyncContextMap.Key<?> key) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null);
            return this.keyOne.equals(key) || this.keyTwo.equals(key) || this.keyThree.equals(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        @Nullable
        public <T> T put(AsyncContextMap.Key<T> key, T value, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeAsyncContextMap(this.keyOne, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree)) ? this.valueOne : owner.put(key, value));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, value, this.keyThree, this.valueThree)) ? this.valueTwo : owner.put(key, value));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, value)) ? this.valueThree : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> map) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null);
            switch (map.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    PutFourBuilder builder = new PutFourBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                    map.forEach(builder);
                    return builder.build();
                }
                case 2: {
                    PutFiveBuilder builder = new PutFiveBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                    map.forEach(builder);
                    return builder.build();
                }
                case 3: {
                    PutSixBuilder builder = new PutSixBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                    map.forEach(builder);
                    return builder.build();
                }
            }
            PutSevenBuilder builder = new PutSevenBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, map.size());
            map.forEach(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> key, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree)) ? this.valueOne : owner.remove(key));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree)) ? this.valueTwo : owner.remove(key));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo)) ? this.valueThree : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null);
            MutableInt removeIndexMask = new MutableInt();
            entries.forEach((? super T k) -> {
                if (this.keyOne.equals(k)) {
                    removeIndexMask.value |= 1;
                } else if (this.keyTwo.equals(k)) {
                    removeIndexMask.value |= 2;
                } else if (this.keyThree.equals(k)) {
                    removeIndexMask.value |= 4;
                }
            });
            CopyAsyncContextMap newMap = this.removeAll(removeIndexMask);
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(entries);
        }

        @Nullable
        private CopyAsyncContextMap removeAll(MutableInt removeIndexMask) {
            assert (this.keyOne != null && this.keyTwo != null && this.keyThree != null);
            if ((removeIndexMask.value & 7) == 7) {
                return EmptyAsyncContextMap.INSTANCE;
            }
            if ((removeIndexMask.value & 4) == 4) {
                if ((removeIndexMask.value & 2) == 2) {
                    return new OneAsyncContextMap(this.keyOne, this.valueOne);
                }
                if ((removeIndexMask.value & 1) == 1) {
                    return new OneAsyncContextMap(this.keyTwo, this.valueTwo);
                }
                return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
            }
            if ((removeIndexMask.value & 2) == 2) {
                if ((removeIndexMask.value & 1) == 1) {
                    return new OneAsyncContextMap(this.keyThree, this.valueThree);
                }
                return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree);
            }
            if ((removeIndexMask.value & 1) == 1) {
                return new TwoAsyncContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
            }
            return null;
        }

        @Override
        @Nullable
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            if (!consumer.test(this.keyTwo, this.valueTwo)) {
                return this.keyTwo;
            }
            return consumer.test(this.keyThree, this.valueThree) ? null : this.keyThree;
        }

        @Override
        public void accept(AsyncContextMap.Key<?> key, Object value) {
            this.test(key, value);
        }

        @Override
        public boolean test(AsyncContextMap.Key<?> key, Object value) {
            if (this.keyOne == null) {
                this.keyOne = key;
                this.valueOne = value;
            } else if (this.keyTwo == null) {
                this.keyTwo = key;
                this.valueTwo = value;
            } else {
                assert (this.keyThree == null);
                this.keyThree = key;
                this.valueThree = value;
                return false;
            }
            return true;
        }

        private static final class PutSevenBuilder
        extends AbstractPutSevenBuilder {
            PutSevenBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree, int putAllMapSize) {
                super(3 + putAllMapSize << 1, 6);
                this.pairs[0] = keyOne;
                this.pairs[1] = valueOne;
                this.pairs[2] = keyTwo;
                this.pairs[3] = valueTwo;
                this.pairs[4] = keyThree;
                this.pairs[5] = valueThree;
            }

            CopyAsyncContextMap build() {
                if (this.nextIndex == 6) {
                    return new ThreeAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5]);
                }
                if (this.nextIndex == 8) {
                    return new FourAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7]);
                }
                if (this.nextIndex == 10) {
                    return new FiveAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9]);
                }
                if (this.nextIndex == 12) {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9], (AsyncContextMap.Key)this.pairs[10], this.pairs[11]);
                }
                if (this.nextIndex == this.pairs.length) {
                    return new SevenOrMoreAsyncContextMap(this.pairs);
                }
                return new SevenOrMoreAsyncContextMap(Arrays.copyOf(this.pairs, this.nextIndex));
            }
        }

        private static final class PutSixBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            private final AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            @Nullable
            private AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;
            @Nullable
            private AsyncContextMap.Key<?> keySix;
            @Nullable
            private Object valueSix;

            PutSixBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
                this.keyThree = keyThree;
                this.valueThree = valueThree;
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree.equals(key)) {
                    this.valueThree = o;
                } else if (this.keyFour == null) {
                    this.keyFour = key;
                    this.valueFour = o;
                } else if (this.keyFive == null) {
                    this.keyFive = key;
                    this.valueFive = o;
                } else {
                    assert (this.keySix == null);
                    this.keySix = key;
                    this.valueSix = o;
                    return false;
                }
                return true;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            CopyAsyncContextMap build() {
                if (this.keyFour == null) {
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                if (this.keyFive == null) {
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                if (this.keySix == null) {
                    return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
        }

        private static final class PutFiveBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            private final AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            @Nullable
            private AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;

            PutFiveBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
                this.keyThree = keyThree;
                this.valueThree = valueThree;
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree.equals(key)) {
                    this.valueThree = o;
                } else if (this.keyFour == null) {
                    this.keyFour = key;
                    this.valueFour = o;
                } else {
                    assert (this.keyFive == null);
                    this.keyFive = key;
                    this.valueFive = o;
                    return false;
                }
                return true;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            CopyAsyncContextMap build() {
                if (this.keyFour == null) {
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                if (this.keyFive == null) {
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
        }

        private static final class PutFourBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            private final AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;

            PutFourBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, AsyncContextMap.Key<?> keyThree, @Nullable Object valueThree) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
                this.keyThree = keyThree;
                this.valueThree = valueThree;
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree.equals(key)) {
                    this.valueThree = o;
                } else {
                    assert (this.keyFour == null);
                    this.keyFour = key;
                    this.valueFour = o;
                    return false;
                }
                return true;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            CopyAsyncContextMap build() {
                if (this.keyFour == null) {
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }
        }
    }

    private static final class TwoAsyncContextMap
    implements CopyAsyncContextMap,
    BiConsumer<AsyncContextMap.Key<?>, Object>,
    BiPredicate<AsyncContextMap.Key<?>, Object> {
        @Nullable
        private AsyncContextMap.Key<?> keyOne;
        @Nullable
        private Object valueOne;
        @Nullable
        private AsyncContextMap.Key<?> keyTwo;
        @Nullable
        private Object valueTwo;

        TwoAsyncContextMap() {
        }

        TwoAsyncContextMap(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
        }

        @Override
        @Nullable
        public <T> T get(AsyncContextMap.Key<T> key) {
            assert (this.keyOne != null && this.keyTwo != null);
            return (T)(this.keyOne.equals(key) ? this.valueOne : (this.keyTwo.equals(key) ? this.valueTwo : null));
        }

        @Override
        public boolean containsKey(AsyncContextMap.Key<?> key) {
            assert (this.keyOne != null && this.keyTwo != null);
            return this.keyOne.equals(key) || this.keyTwo.equals(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public <T> T put(AsyncContextMap.Key<T> key, T value, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoAsyncContextMap(this.keyOne, value, this.keyTwo, this.valueTwo)) ? this.valueOne : owner.put(key, value));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, value)) ? this.valueTwo : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> map) {
            assert (this.keyOne != null && this.keyTwo != null);
            switch (map.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    PutThreeBuilder builder = new PutThreeBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                    map.forEach(builder);
                    return builder.build();
                }
                case 2: {
                    PutFourBuilder builder = new PutFourBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                    map.forEach(builder);
                    return builder.build();
                }
                case 3: {
                    PutFiveBuilder builder = new PutFiveBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                    map.forEach(builder);
                    return builder.build();
                }
                case 4: {
                    PutSixBuilder builder = new PutSixBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                    map.forEach(builder);
                    return builder.build();
                }
            }
            PutSevenBuilder builder = new PutSevenBuilder(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, map.size());
            map.forEach(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> key, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null);
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new OneAsyncContextMap(this.keyTwo, this.valueTwo)) ? this.valueOne : owner.remove(key));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new OneAsyncContextMap(this.keyOne, this.valueOne)) ? this.valueTwo : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.keyOne != null && this.keyTwo != null);
            MutableInt removeIndexMask = new MutableInt();
            entries.forEach((? super T k) -> {
                if (this.keyOne.equals(k)) {
                    removeIndexMask.value |= 1;
                } else if (this.keyTwo.equals(k)) {
                    removeIndexMask.value |= 2;
                }
            });
            if ((removeIndexMask.value & 3) == 3) {
                return mapUpdater.compareAndSet(owner, this, EmptyAsyncContextMap.INSTANCE) || owner.removeAll(entries);
            }
            if ((removeIndexMask.value & 2) == 2) {
                return mapUpdater.compareAndSet(owner, this, new OneAsyncContextMap(this.keyOne, this.valueOne)) || owner.removeAll(entries);
            }
            if ((removeIndexMask.value & 1) == 1) {
                return mapUpdater.compareAndSet(owner, this, new OneAsyncContextMap(this.keyTwo, this.valueTwo)) || owner.removeAll(entries);
            }
            return false;
        }

        @Override
        @Nullable
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            return consumer.test(this.keyTwo, this.valueTwo) ? null : this.keyTwo;
        }

        @Override
        public void accept(AsyncContextMap.Key<?> key, Object value) {
            this.test(key, value);
        }

        @Override
        public boolean test(AsyncContextMap.Key<?> key, Object value) {
            if (this.keyOne != null) {
                assert (this.keyTwo == null);
                this.keyTwo = key;
                this.valueTwo = value;
                return false;
            }
            this.keyOne = key;
            this.valueOne = value;
            return true;
        }

        private static final class PutSevenBuilder
        extends AbstractPutSevenBuilder {
            PutSevenBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo, int putAllMapSize) {
                super(2 + putAllMapSize << 1, 4);
                this.pairs[0] = keyOne;
                this.pairs[1] = valueOne;
                this.pairs[2] = keyTwo;
                this.pairs[3] = valueTwo;
            }

            CopyAsyncContextMap build() {
                if (this.nextIndex == 4) {
                    return new TwoAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3]);
                }
                if (this.nextIndex == 6) {
                    return new ThreeAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5]);
                }
                if (this.nextIndex == 8) {
                    return new FourAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7]);
                }
                if (this.nextIndex == 10) {
                    return new FiveAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9]);
                }
                if (this.nextIndex == 12) {
                    return new SixAsyncContextMap((AsyncContextMap.Key)this.pairs[0], this.pairs[1], (AsyncContextMap.Key)this.pairs[2], this.pairs[3], (AsyncContextMap.Key)this.pairs[4], this.pairs[5], (AsyncContextMap.Key)this.pairs[6], this.pairs[7], (AsyncContextMap.Key)this.pairs[8], this.pairs[9], (AsyncContextMap.Key)this.pairs[10], this.pairs[11]);
                }
                if (this.nextIndex == this.pairs.length) {
                    return new SevenOrMoreAsyncContextMap(this.pairs);
                }
                return new SevenOrMoreAsyncContextMap(Arrays.copyOf(this.pairs, this.nextIndex));
            }
        }

        private static final class PutSixBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            @Nullable
            private AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            @Nullable
            private AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;
            @Nullable
            private AsyncContextMap.Key<?> keySix;
            @Nullable
            private Object valueSix;

            PutSixBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree == null) {
                    this.keyThree = key;
                    this.valueThree = o;
                } else if (this.keyFour == null) {
                    this.keyFour = key;
                    this.valueFour = o;
                } else if (this.keyFive == null) {
                    this.keyFive = key;
                    this.valueFive = o;
                } else {
                    assert (this.keySix == null);
                    this.keySix = key;
                    this.valueSix = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                if (this.keyThree == null) {
                    return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                }
                if (this.keyFour == null) {
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                if (this.keyFive == null) {
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                if (this.keySix == null) {
                    return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }
        }

        private static final class PutFiveBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            @Nullable
            private AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            @Nullable
            private AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;

            PutFiveBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree == null) {
                    this.keyThree = key;
                    this.valueThree = o;
                } else if (this.keyFour == null) {
                    this.keyFour = key;
                    this.valueFour = o;
                } else {
                    assert (this.keyFive == null);
                    this.keyFive = key;
                    this.valueFive = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                if (this.keyThree == null) {
                    return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                }
                if (this.keyFour == null) {
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                if (this.keyFive == null) {
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }
        }

        private static final class PutFourBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            @Nullable
            private AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;

            PutFourBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else if (this.keyThree == null) {
                    this.keyThree = key;
                    this.valueThree = o;
                } else {
                    assert (this.keyFour == null);
                    this.keyFour = key;
                    this.valueFour = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                if (this.keyThree == null) {
                    return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                }
                if (this.keyFour == null) {
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }
        }

        private static final class PutThreeBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            private final AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            @Nullable
            private AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;

            PutThreeBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne, AsyncContextMap.Key<?> keyTwo, @Nullable Object valueTwo) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
                this.keyTwo = keyTwo;
                this.valueTwo = valueTwo;
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo.equals(key)) {
                    this.valueTwo = o;
                } else {
                    assert (this.keyThree == null);
                    this.keyThree = key;
                    this.valueThree = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                return this.keyThree == null ? new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo) : new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }
        }
    }

    private static final class OneAsyncContextMap
    implements CopyAsyncContextMap,
    BiConsumer<AsyncContextMap.Key<?>, Object>,
    BiPredicate<AsyncContextMap.Key<?>, Object> {
        @Nullable
        private AsyncContextMap.Key<?> key;
        @Nullable
        private Object value;

        OneAsyncContextMap() {
        }

        OneAsyncContextMap(AsyncContextMap.Key<?> key, @Nullable Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @Nullable
        public <T> T get(AsyncContextMap.Key<T> key) {
            assert (this.key != null);
            return (T)(this.key.equals(key) ? this.value : null);
        }

        @Override
        public boolean containsKey(AsyncContextMap.Key<?> key) {
            assert (this.key != null);
            return this.key.equals(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public <T> T put(AsyncContextMap.Key<T> key, T value, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.key != null);
            if (this.key.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new OneAsyncContextMap(this.key, value)) ? this.value : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new TwoAsyncContextMap(this.key, this.value, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> map) {
            assert (this.key != null);
            switch (map.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    PutTwoBuilder builder = new PutTwoBuilder(this.key, this.value);
                    map.forEach(builder);
                    return builder.build();
                }
                case 2: {
                    PutThreeBuilder builder = new PutThreeBuilder(this.key, this.value);
                    map.forEach(builder);
                    return builder.build();
                }
                case 3: {
                    PutFourBuilder builder = new PutFourBuilder(this.key, this.value);
                    map.forEach(builder);
                    return builder.build();
                }
                case 4: {
                    PutFiveBuilder builder = new PutFiveBuilder(this.key, this.value);
                    map.forEach(builder);
                    return builder.build();
                }
                case 5: {
                    PutSixBuilder builder = new PutSixBuilder(this.key, this.value);
                    map.forEach(builder);
                    return builder.build();
                }
            }
            return new SevenOrMoreAsyncContextMap(this.key, this.value).putAll(map);
        }

        @Override
        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> key, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.key != null);
            if (this.key.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, EmptyAsyncContextMap.INSTANCE) ? this.value : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            assert (this.key != null);
            MutableInt index = new MutableInt();
            entries.forEach((? super T key) -> {
                if (this.key.equals(key)) {
                    index.value = 1;
                }
            });
            if (index.value != 0) {
                return mapUpdater.compareAndSet(owner, this, EmptyAsyncContextMap.INSTANCE) || owner.removeAll(entries);
            }
            return false;
        }

        @Override
        @Nullable
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
            return consumer.test(this.key, this.value) ? null : this.key;
        }

        @Override
        public void accept(AsyncContextMap.Key<?> key, Object value) {
            this.test(key, value);
        }

        @Override
        public boolean test(AsyncContextMap.Key<?> key, Object o) {
            assert (this.key == null);
            this.key = key;
            this.value = o;
            return false;
        }

        private static final class PutSixBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            @Nullable
            private AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            @Nullable
            private AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            @Nullable
            private AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;
            @Nullable
            private AsyncContextMap.Key<?> keySix;
            @Nullable
            private Object valueSix;

            PutSixBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo == null) {
                    this.keyTwo = key;
                    this.valueTwo = o;
                } else if (this.keyThree == null) {
                    this.keyThree = key;
                    this.valueThree = o;
                } else if (this.keyFour == null) {
                    this.keyFour = key;
                    this.valueFour = o;
                } else if (this.keyFive == null) {
                    this.keyFive = key;
                    this.valueFive = o;
                } else {
                    assert (this.keySix == null);
                    this.keySix = key;
                    this.valueSix = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                assert (this.keyTwo != null && this.keyThree != null && this.keyFour != null && this.keyFive != null);
                if (this.keySix == null) {
                    return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new SixAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
        }

        private static final class PutFiveBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            @Nullable
            private AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            @Nullable
            private AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;
            @Nullable
            private AsyncContextMap.Key<?> keyFive;
            @Nullable
            private Object valueFive;

            PutFiveBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo == null) {
                    this.keyTwo = key;
                    this.valueTwo = o;
                } else if (this.keyThree == null) {
                    this.keyThree = key;
                    this.valueThree = o;
                } else if (this.keyFour == null) {
                    this.keyFour = key;
                    this.valueFour = o;
                } else {
                    assert (this.keyFive == null);
                    this.keyFive = key;
                    this.valueFive = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                assert (this.keyTwo != null && this.keyThree != null && this.keyFour != null);
                if (this.keyFive == null) {
                    return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                return new FiveAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
        }

        private static final class PutFourBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            @Nullable
            private AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            @Nullable
            private AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;
            @Nullable
            private AsyncContextMap.Key<?> keyFour;
            @Nullable
            private Object valueFour;

            PutFourBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo == null) {
                    this.keyTwo = key;
                    this.valueTwo = o;
                } else if (this.keyThree == null) {
                    this.keyThree = key;
                    this.valueThree = o;
                } else {
                    assert (this.keyFour == null);
                    this.keyFour = key;
                    this.valueFour = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                assert (this.keyTwo != null && this.keyThree != null);
                if (this.keyFour == null) {
                    return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                return new FourAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }
        }

        private static final class PutThreeBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            @Nullable
            private AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;
            @Nullable
            private AsyncContextMap.Key<?> keyThree;
            @Nullable
            private Object valueThree;

            PutThreeBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (this.keyOne.equals(key)) {
                    this.valueOne = o;
                } else if (this.keyTwo == null) {
                    this.keyTwo = key;
                    this.valueTwo = o;
                } else {
                    assert (this.keyThree == null);
                    this.keyThree = key;
                    this.valueThree = o;
                    return false;
                }
                return true;
            }

            CopyAsyncContextMap build() {
                assert (this.keyTwo != null);
                if (this.keyThree == null) {
                    return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                }
                return new ThreeAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
            }
        }

        private static final class PutTwoBuilder
        implements BiPredicate<AsyncContextMap.Key<?>, Object>,
        BiConsumer<AsyncContextMap.Key<?>, Object> {
            private final AsyncContextMap.Key<?> keyOne;
            @Nullable
            private Object valueOne;
            @Nullable
            private AsyncContextMap.Key<?> keyTwo;
            @Nullable
            private Object valueTwo;

            PutTwoBuilder(AsyncContextMap.Key<?> keyOne, @Nullable Object valueOne) {
                this.keyOne = keyOne;
                this.valueOne = valueOne;
            }

            @Override
            public void accept(AsyncContextMap.Key<?> key, Object o) {
                this.test(key, o);
            }

            @Override
            public boolean test(AsyncContextMap.Key<?> key, Object o) {
                if (!this.keyOne.equals(key)) {
                    assert (this.keyTwo == null);
                    this.keyTwo = key;
                    this.valueTwo = o;
                    return false;
                }
                this.valueOne = o;
                return true;
            }

            CopyAsyncContextMap build() {
                if (this.keyTwo == null) {
                    return new OneAsyncContextMap(this.keyOne, this.valueOne);
                }
                return new TwoAsyncContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
            }
        }
    }

    private static final class EmptyAsyncContextMap
    implements CopyAsyncContextMap {
        static final CopyAsyncContextMap INSTANCE = new EmptyAsyncContextMap();

        private EmptyAsyncContextMap() {
        }

        @Override
        @Nullable
        public <T> T get(AsyncContextMap.Key<T> key) {
            return null;
        }

        @Override
        public boolean containsKey(AsyncContextMap.Key<?> key) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        @Nullable
        public <T> T put(AsyncContextMap.Key<T> key, T value, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            return mapUpdater.compareAndSet(owner, this, new OneAsyncContextMap(key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> map) {
            switch (map.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    OneAsyncContextMap newMap = new OneAsyncContextMap();
                    map.forEach(newMap);
                    return newMap;
                }
                case 2: {
                    TwoAsyncContextMap newMap = new TwoAsyncContextMap();
                    map.forEach(newMap);
                    return newMap;
                }
                case 3: {
                    ThreeAsyncContextMap newMap = new ThreeAsyncContextMap();
                    map.forEach(newMap);
                    return newMap;
                }
                case 4: {
                    FourAsyncContextMap newMap = new FourAsyncContextMap();
                    map.forEach(newMap);
                    return newMap;
                }
                case 5: {
                    FiveAsyncContextMap newMap = new FiveAsyncContextMap();
                    map.forEach(newMap);
                    return newMap;
                }
                case 6: {
                    SixAsyncContextMap newMap = new SixAsyncContextMap();
                    map.forEach(newMap);
                    return newMap;
                }
            }
            return new SevenOrMoreAsyncContextMap(new Object[0]).putAll(map);
        }

        @Override
        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> key, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            return null;
        }

        @Override
        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries, CopyOnWriteAsyncContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> mapUpdater) {
            return false;
        }

        @Override
        @Nullable
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
            return null;
        }
    }

    static interface CopyAsyncContextMap {
        @Nullable
        public <T> T get(AsyncContextMap.Key<T> var1);

        public boolean containsKey(AsyncContextMap.Key<?> var1);

        public boolean isEmpty();

        public int size();

        @Nullable
        public <T> T put(AsyncContextMap.Key<T> var1, T var2, CopyOnWriteAsyncContextMap var3, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> var4);

        public CopyAsyncContextMap putAll(Map<AsyncContextMap.Key<?>, Object> var1);

        @Nullable
        public <T> T remove(AsyncContextMap.Key<T> var1, CopyOnWriteAsyncContextMap var2, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> var3);

        public boolean removeAll(Iterable<AsyncContextMap.Key<?>> var1, CopyOnWriteAsyncContextMap var2, AtomicReferenceFieldUpdater<CopyOnWriteAsyncContextMap, CopyAsyncContextMap> var3);

        @Nullable
        public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> var1);
    }
}

