/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class FilterPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Predicate<? super T> predicate;

    FilterPublisher(Publisher<T> source, Predicate<? super T> predicate, Executor executor) {
        super(source, executor);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(final PublisherSource.Subscriber<? super T> subscriber) {
        return new PublisherSource.Subscriber<T>(){
            @Nullable
            private PublisherSource.Subscription subscription;

            @Override
            public void onSubscribe(PublisherSource.Subscription s) {
                if (SubscriberUtils.checkDuplicateSubscription(this.subscription, s)) {
                    this.subscription = ConcurrentSubscription.wrap(s);
                    subscriber.onSubscribe(this.subscription);
                }
            }

            @Override
            public void onNext(T t) {
                if (FilterPublisher.this.predicate.test(t)) {
                    subscriber.onNext(t);
                } else {
                    assert (this.subscription != null) : "Subscription can not be null in onNext.";
                    this.subscription.request(1L);
                }
            }

            @Override
            public void onError(Throwable t) {
                subscriber.onError(t);
            }

            @Override
            public void onComplete() {
                subscriber.onComplete();
            }
        };
    }
}

