/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class SingleDoOnUtils {
    private SingleDoOnUtils() {
    }

    static <X> Supplier<SingleSource.Subscriber<? super X>> doOnSubscribeSupplier(final Consumer<Cancellable> onSubscribe) {
        Objects.requireNonNull(onSubscribe);
        SingleSource.Subscriber subscriber = new SingleSource.Subscriber<X>(){

            @Override
            public void onSubscribe(Cancellable cancellable) {
                onSubscribe.accept(cancellable);
            }

            @Override
            public void onSuccess(@Nullable X result) {
            }

            @Override
            public void onError(Throwable t) {
            }
        };
        return () -> subscriber;
    }

    static <X> Supplier<SingleSource.Subscriber<? super X>> doOnSuccessSupplier(final Consumer<X> onSuccess) {
        Objects.requireNonNull(onSuccess);
        SingleSource.Subscriber subscriber = new SingleSource.Subscriber<X>(){

            @Override
            public void onSubscribe(Cancellable cancellable) {
            }

            @Override
            public void onSuccess(@Nullable X result) {
                onSuccess.accept(result);
            }

            @Override
            public void onError(Throwable t) {
            }
        };
        return () -> subscriber;
    }

    static <X> Supplier<SingleSource.Subscriber<? super X>> doOnErrorSupplier(final Consumer<Throwable> onError) {
        Objects.requireNonNull(onError);
        SingleSource.Subscriber subscriber = new SingleSource.Subscriber<X>(){

            @Override
            public void onSubscribe(Cancellable cancellable) {
            }

            @Override
            public void onSuccess(@Nullable X result) {
            }

            @Override
            public void onError(Throwable t) {
                onError.accept(t);
            }
        };
        return () -> subscriber;
    }
}

