/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.ComposedCancellable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import java.util.Objects;

final class WhenCancellableSingle<T>
extends AbstractSynchronousSingleOperator<T, T> {
    private final Cancellable cancellable;
    private final boolean before;

    WhenCancellableSingle(Single<T> original, Cancellable cancellable, boolean before, Executor executor) {
        super(original, executor);
        this.cancellable = Objects.requireNonNull(cancellable);
        this.before = before;
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        return new DoCancellableSingleSubscriber<T>(subscriber, this);
    }

    private static final class DoCancellableSingleSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> original;
        private final WhenCancellableSingle parent;

        DoCancellableSingleSubscriber(SingleSource.Subscriber<? super T> original, WhenCancellableSingle parent) {
            this.original = original;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Cancellable originalCancellable) {
            this.original.onSubscribe(this.parent.before ? new ComposedCancellable(this.parent.cancellable, originalCancellable) : new ComposedCancellable(originalCancellable, this.parent.cancellable));
        }

        @Override
        public void onSuccess(T value) {
            this.original.onSuccess(value);
        }

        @Override
        public void onError(Throwable t) {
            this.original.onError(t);
        }
    }
}

