/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.function.Supplier;

final class WhenSubscriptionPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Supplier<? extends PublisherSource.Subscription> subscriptionSupplier;
    private final boolean before;

    WhenSubscriptionPublisher(Publisher<T> original, Supplier<? extends PublisherSource.Subscription> subscriptionSupplier, boolean before, Executor executor) {
        super(original, executor);
        this.subscriptionSupplier = Objects.requireNonNull(subscriptionSupplier);
        this.before = before;
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new DoSubscriptionPublisherSubscriber<T>(subscriber, this);
    }

    private static final class DoSubscriptionPublisherSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> original;
        private final WhenSubscriptionPublisher<T> parent;

        DoSubscriptionPublisherSubscriber(PublisherSource.Subscriber<? super T> original, WhenSubscriptionPublisher<T> parent) {
            this.original = original;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            PublisherSource.Subscription subscription = (PublisherSource.Subscription)((WhenSubscriptionPublisher)this.parent).subscriptionSupplier.get();
            this.original.onSubscribe(((WhenSubscriptionPublisher)this.parent).before ? new BeforeSubscription(subscription, s) : new BeforeSubscription(s, subscription));
        }

        @Override
        public void onNext(T t) {
            this.original.onNext(t);
        }

        @Override
        public void onComplete() {
            this.original.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            this.original.onError(t);
        }

        private static final class BeforeSubscription
        implements PublisherSource.Subscription {
            private final PublisherSource.Subscription first;
            private final PublisherSource.Subscription second;

            BeforeSubscription(PublisherSource.Subscription first, PublisherSource.Subscription second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public void request(long n) {
                try {
                    this.first.request(n);
                }
                finally {
                    this.second.request(n);
                }
            }

            @Override
            public void cancel() {
                try {
                    this.first.cancel();
                }
                finally {
                    this.second.cancel();
                }
            }
        }
    }
}

