/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.ContentCodings;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class ContentCodingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory,
HttpExecutionStrategyInfluencer {
    private final List<ContentCodec> supportedCodings;
    @Nullable
    private final CharSequence acceptedEncodingsHeader;

    public ContentCodingHttpRequesterFilter(List<ContentCodec> supportedCodings) {
        this.supportedCodings = new ArrayList<ContentCodec>(supportedCodings);
        this.acceptedEncodingsHeader = ContentCodingHttpRequesterFilter.buildAcceptEncodingsHeader(supportedCodings);
    }

    @Override
    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            @Override
            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return Single.defer(() -> ContentCodingHttpRequesterFilter.this.codecTransformBidirectionalIfNeeded(this.delegate(), strategy, request));
            }
        };
    }

    @Override
    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            @Override
            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return Single.defer(() -> ContentCodingHttpRequesterFilter.this.codecTransformBidirectionalIfNeeded(this.delegate(), strategy, request));
            }
        };
    }

    @Override
    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }

    private Single<StreamingHttpResponse> codecTransformBidirectionalIfNeeded(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        BufferAllocator alloc = delegate.executionContext().bufferAllocator();
        HeaderUtils.setAcceptEncoding(request.headers(), this.acceptedEncodingsHeader);
        ContentCodingHttpRequesterFilter.encodePayloadContentIfAvailable(request, alloc);
        return this.decodePayloadContentIfEncoded(delegate.request(strategy, request), alloc);
    }

    private Single<StreamingHttpResponse> decodePayloadContentIfEncoded(Single<StreamingHttpResponse> responseSingle, BufferAllocator allocator) {
        return responseSingle.map(response -> {
            ContentCodec coding = HeaderUtils.identifyContentEncodingOrNullIfIdentity(response.headers(), this.supportedCodings);
            if (coding != null) {
                response.transformPayloadBody(bufferPublisher -> coding.decode((Publisher<Buffer>)bufferPublisher, allocator));
            }
            return response;
        });
    }

    @Nullable
    private static CharSequence buildAcceptEncodingsHeader(List<ContentCodec> codecs) {
        StringBuilder builder = new StringBuilder();
        for (ContentCodec enc : codecs) {
            if (enc == ContentCodings.identity()) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(enc.name());
        }
        return builder.length() > 0 ? CharSequences.newAsciiString(builder.toString()) : null;
    }

    private static void encodePayloadContentIfAvailable(StreamingHttpRequest request, BufferAllocator allocator) {
        ContentCodec coding = request.encoding();
        if (coding != null && !coding.equals(ContentCodings.identity())) {
            HeaderUtils.setContentEncoding(request.headers(), coding.name());
            request.transformPayloadBody(pub -> coding.encode((Publisher<Buffer>)pub, allocator));
        }
    }
}

