/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.serialization.api.Serializer;
import java.util.function.Predicate;

final class DefaultClassHttpDeserializer<T>
implements HttpDeserializer<T> {
    private final Serializer serializer;
    private final Class<T> type;
    private final Predicate<HttpHeaders> checkContentType;

    DefaultClassHttpDeserializer(Serializer serializer, Class<T> type, Predicate<HttpHeaders> checkContentType) {
        this.serializer = serializer;
        this.type = type;
        this.checkContentType = checkContentType;
    }

    @Override
    public T deserialize(HttpHeaders headers, Buffer payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return this.serializer.deserializeAggregatedSingle(payload, this.type);
    }

    @Override
    public BlockingIterable<T> deserialize(HttpHeaders headers, BlockingIterable<Buffer> payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return this.serializer.deserialize(payload, this.type);
    }

    @Override
    public Publisher<T> deserialize(HttpHeaders headers, Publisher<Buffer> payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return this.serializer.deserialize(payload, this.type);
    }
}

