/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingHttpConnection;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpConnection;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.BlockingStreamingToStreamingService;
import io.servicetalk.http.api.BlockingToStreamingService;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.PayloadInfo;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.ServiceToStreamingService;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientToBlockingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientToBlockingStreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientToHttpClient;
import io.servicetalk.http.api.StreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionToBlockingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionToBlockingStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionToHttpConnection;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceToBlockingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceToBlockingStreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceToHttpService;

public final class HttpApiConversions {
    private HttpApiConversions() {
    }

    public static ReservedHttpConnection toReservedConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpClientToHttpClient.ReservedStreamingHttpConnectionToReservedHttpConnection(original, influencer);
    }

    public static ReservedBlockingHttpConnection toReservedBlockingConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpClientToBlockingHttpClient.ReservedStreamingHttpConnectionToReservedBlockingHttpConnection(original, influencer);
    }

    public static ReservedBlockingStreamingHttpConnection toReservedBlockingStreamingConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpClientToBlockingStreamingHttpClient.ReservedStreamingHttpConnectionToBlockingStreaming(original, influencer);
    }

    public static HttpConnection toConnection(StreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpConnectionToHttpConnection(original, influencer);
    }

    public static BlockingHttpConnection toBlockingConnection(StreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpConnectionToBlockingHttpConnection(original, influencer);
    }

    public static BlockingStreamingHttpConnection toBlockingStreamingConnection(StreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpConnectionToBlockingStreamingHttpConnection(original, influencer);
    }

    public static HttpClient toClient(StreamingHttpClient original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpClientToHttpClient(original, influencer);
    }

    public static BlockingHttpClient toBlockingClient(StreamingHttpClient original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpClientToBlockingHttpClient(original, influencer);
    }

    public static BlockingStreamingHttpClient toBlockingStreamingClient(StreamingHttpClient original, HttpExecutionStrategyInfluencer influencer) {
        return new StreamingHttpClientToBlockingStreamingHttpClient(original, influencer);
    }

    public static ServiceAdapterHolder toStreamingHttpService(HttpService service, HttpExecutionStrategyInfluencer influencer) {
        return new ServiceToStreamingService(service, influencer);
    }

    public static ServiceAdapterHolder toStreamingHttpService(BlockingStreamingHttpService service, HttpExecutionStrategyInfluencer influencer) {
        return new BlockingStreamingToStreamingService(service, influencer);
    }

    public static ServiceAdapterHolder toStreamingHttpService(BlockingHttpService service, HttpExecutionStrategyInfluencer influencer) {
        return new BlockingToStreamingService(service, influencer);
    }

    public static boolean isSafeToAggregate(HttpMetaData metadata) {
        return metadata instanceof PayloadInfo && ((PayloadInfo)((Object)metadata)).isSafeToAggregate();
    }

    public static boolean mayHaveTrailers(HttpMetaData metadata) {
        return metadata instanceof PayloadInfo && ((PayloadInfo)((Object)metadata)).mayHaveTrailers() || HeaderUtils.isTransferEncodingChunked(metadata.headers());
    }

    public static BlockingHttpService toBlockingHttpService(StreamingHttpService service) {
        return new StreamingHttpServiceToBlockingHttpService(service);
    }

    public static HttpService toHttpService(StreamingHttpService service) {
        return new StreamingHttpServiceToHttpService(service);
    }

    public static BlockingStreamingHttpService toBlockingStreamingHttpService(StreamingHttpService service) {
        return new StreamingHttpServiceToBlockingStreamingHttpService(service);
    }

    public static interface ServiceAdapterHolder {
        public StreamingHttpService adaptor();

        public HttpExecutionStrategy serviceInvocationStrategy();
    }
}

