/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.StrategyInfluencerAwareConversions;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface MultiAddressHttpClientFilterFactory<U> {
    public StreamingHttpClientFilter create(U var1, FilterableStreamingHttpClient var2);

    default public MultiAddressHttpClientFilterFactory<U> append(MultiAddressHttpClientFilterFactory<U> before) {
        Objects.requireNonNull(before);
        return (group, client) -> this.create(group, before.create(group, client));
    }

    default public StreamingHttpClientFilterFactory asClientFilter(U address) {
        return StrategyInfluencerAwareConversions.toClientFactory(address, this);
    }

    public static <U> MultiAddressHttpClientFilterFactory<U> from(BiFunction<U, FilterableStreamingHttpClient, StreamingHttpClientFilter> function) {
        return function::apply;
    }

    public static <U> MultiAddressHttpClientFilterFactory<U> from(Function<FilterableStreamingHttpClient, StreamingHttpClientFilter> function) {
        Objects.requireNonNull(function);
        return (__, client) -> (StreamingHttpClientFilter)function.apply(client);
    }
}

