/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.ClientInvoker;
import io.servicetalk.http.api.ExecutionContextOverridingServiceContext;
import io.servicetalk.http.api.FunctionToSingle;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpService;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

final class NoOffloadsHttpExecutionStrategy
implements HttpExecutionStrategy {
    static final HttpExecutionStrategy NO_OFFLOADS_NO_EXECUTOR = new NoOffloadsHttpExecutionStrategy();
    @Nullable
    private final Executor executor;

    private NoOffloadsHttpExecutionStrategy() {
        this.executor = null;
    }

    NoOffloadsHttpExecutionStrategy(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public <FS> Single<StreamingHttpResponse> invokeClient(Executor fallback, Publisher<Object> flattenedRequest, FS flushStrategy, ClientInvoker<FS> client) {
        return client.invokeClient(flattenedRequest, flushStrategy);
    }

    @Override
    public Publisher<Object> invokeService(Executor fallback, StreamingHttpRequest request, Function<StreamingHttpRequest, Publisher<Object>> service, BiFunction<Throwable, Executor, Publisher<Object>> errorHandler) {
        return service.apply(request);
    }

    @Override
    public StreamingHttpService offloadService(Executor fallback, StreamingHttpService handler) {
        return (ctx, request, responseFactory) -> {
            ExecutionContextOverridingServiceContext wrappedCtx = new ExecutionContextOverridingServiceContext(ctx, this, fallback);
            return handler.handle(wrappedCtx, request, responseFactory);
        };
    }

    @Override
    public boolean isMetadataReceiveOffloaded() {
        return false;
    }

    @Override
    public boolean isDataReceiveOffloaded() {
        return false;
    }

    @Override
    public boolean isSendOffloaded() {
        return false;
    }

    @Override
    public HttpExecutionStrategy merge(HttpExecutionStrategy other) {
        return this;
    }

    @Override
    public <T> Single<T> invokeService(Executor fallback, Function<Executor, T> service) {
        return new FunctionToSingle<Executor, T>(service, Executors.immediate());
    }

    @Override
    public <T> Single<T> offloadSend(Executor fallback, Single<T> original) {
        return original;
    }

    @Override
    public <T> Single<T> offloadReceive(Executor fallback, Single<T> original) {
        return original;
    }

    @Override
    public <T> Publisher<T> offloadSend(Executor fallback, Publisher<T> original) {
        return original;
    }

    @Override
    public <T> Publisher<T> offloadReceive(Executor fallback, Publisher<T> original) {
        return original;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }
}

