/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;

public final class StrategyInfluencerChainBuilder {
    private static final HttpExecutionStrategyInfluencer NO_INFLUENCE = other -> other;
    private final Deque<HttpExecutionStrategyInfluencer> influencers;

    public StrategyInfluencerChainBuilder() {
        this.influencers = new LinkedList<HttpExecutionStrategyInfluencer>();
    }

    private StrategyInfluencerChainBuilder(Deque<HttpExecutionStrategyInfluencer> influencers) {
        this.influencers = new LinkedList<HttpExecutionStrategyInfluencer>(influencers);
    }

    public void prepend(HttpExecutionStrategyInfluencer influencer) {
        this.influencers.addFirst(Objects.requireNonNull(influencer));
    }

    public boolean prependIfInfluencer(Object mayBeInfluencer) {
        if (mayBeInfluencer instanceof HttpExecutionStrategyInfluencer) {
            this.prepend((HttpExecutionStrategyInfluencer)mayBeInfluencer);
            return true;
        }
        return false;
    }

    public void append(HttpExecutionStrategyInfluencer next) {
        this.influencers.addLast(Objects.requireNonNull(next));
    }

    public boolean appendIfInfluencer(Object mayBeInfluencer) {
        if (mayBeInfluencer instanceof HttpExecutionStrategyInfluencer) {
            this.append((HttpExecutionStrategyInfluencer)mayBeInfluencer);
            return true;
        }
        return false;
    }

    public StrategyInfluencerChainBuilder copy() {
        return new StrategyInfluencerChainBuilder(this.influencers);
    }

    public HttpExecutionStrategyInfluencer build(HttpExecutionStrategy transportStrategy) {
        Objects.requireNonNull(transportStrategy);
        HttpExecutionStrategyInfluencer influencer = this.build0();
        return strategy -> transportStrategy.merge(influencer.influenceStrategy(strategy));
    }

    public HttpExecutionStrategyInfluencer build() {
        return this.build0();
    }

    private HttpExecutionStrategyInfluencer build0() {
        if (this.influencers.isEmpty()) {
            return NO_INFLUENCE;
        }
        HttpExecutionStrategyInfluencer head = NO_INFLUENCE;
        for (HttpExecutionStrategyInfluencer influencer : this.influencers) {
            if (head == NO_INFLUENCE) {
                head = influencer;
                continue;
            }
            HttpExecutionStrategyInfluencer prev = head;
            head = strategy -> influencer.influenceStrategy(prev.influenceStrategy(strategy));
        }
        return head;
    }
}

