/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.DelegatingHttpConnectionContext;
import io.servicetalk.http.api.DelegatingHttpExecutionContext;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpRequestResponseFactory;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.RequestResponseFactories;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpConnectionToHttpConnection;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.util.Objects;

final class StreamingHttpClientToHttpClient
implements HttpClient {
    private final StreamingHttpClient client;
    private final HttpExecutionStrategy strategy;
    private final HttpExecutionContext context;
    private final HttpRequestResponseFactory reqRespFactory;

    StreamingHttpClientToHttpClient(StreamingHttpClient client, HttpExecutionStrategyInfluencer influencer) {
        this.strategy = influencer.influenceStrategy(StreamingHttpConnectionToHttpConnection.DEFAULT_CONNECTION_STRATEGY);
        this.client = client;
        this.context = new DelegatingHttpExecutionContext(client.executionContext()){

            @Override
            public HttpExecutionStrategy executionStrategy() {
                return StreamingHttpClientToHttpClient.this.strategy;
            }
        };
        this.reqRespFactory = RequestResponseFactories.toAggregated(client);
    }

    @Override
    public Single<HttpResponse> request(HttpRequest request) {
        return this.request(this.strategy, request);
    }

    @Override
    public Single<ReservedHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
        return this.reserveConnection(this.strategy, metaData);
    }

    @Override
    public Single<ReservedHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
        return this.client.reserveConnection(strategy, metaData).map(c -> new ReservedStreamingHttpConnectionToReservedHttpConnection((ReservedStreamingHttpConnection)c, this.strategy, this.reqRespFactory));
    }

    @Override
    public Single<HttpResponse> request(HttpExecutionStrategy strategy, HttpRequest request) {
        return this.client.request(strategy, request.toStreamingRequest()).flatMap(StreamingHttpResponse::toResponse);
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.context;
    }

    @Override
    public HttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    @Override
    public void closeGracefully() throws Exception {
        this.client.closeGracefully();
    }

    @Override
    public Completable onClose() {
        return this.client.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.client.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.client.closeAsyncGracefully();
    }

    @Override
    public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }

    @Override
    public StreamingHttpClient asStreamingClient() {
        return this.client;
    }

    static final class ReservedStreamingHttpConnectionToReservedHttpConnection
    implements ReservedHttpConnection {
        private final ReservedStreamingHttpConnection connection;
        private final HttpExecutionStrategy strategy;
        private final HttpConnectionContext context;
        private final HttpExecutionContext executionContext;
        private final HttpRequestResponseFactory reqRespFactory;

        ReservedStreamingHttpConnectionToReservedHttpConnection(ReservedStreamingHttpConnection connection, HttpExecutionStrategyInfluencer influencer) {
            this(connection, influencer.influenceStrategy(StreamingHttpConnectionToHttpConnection.DEFAULT_CONNECTION_STRATEGY), RequestResponseFactories.toAggregated(connection));
        }

        ReservedStreamingHttpConnectionToReservedHttpConnection(ReservedStreamingHttpConnection connection, final HttpExecutionStrategy strategy, HttpRequestResponseFactory reqRespFactory) {
            this.strategy = strategy;
            this.connection = Objects.requireNonNull(connection);
            HttpConnectionContext originalCtx = connection.connectionContext();
            this.executionContext = new DelegatingHttpExecutionContext(connection.executionContext()){

                @Override
                public HttpExecutionStrategy executionStrategy() {
                    return strategy;
                }
            };
            this.context = new DelegatingHttpConnectionContext(originalCtx){

                @Override
                public HttpExecutionContext executionContext() {
                    return executionContext;
                }
            };
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
        }

        @Override
        public Completable releaseAsync() {
            return this.connection.releaseAsync();
        }

        @Override
        public ReservedStreamingHttpConnection asStreamingConnection() {
            return this.connection;
        }

        @Override
        public Single<HttpResponse> request(HttpRequest request) {
            return this.request(this.strategy, request);
        }

        @Override
        public HttpConnectionContext connectionContext() {
            return this.context;
        }

        @Override
        public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
            return this.connection.transportEventStream(eventKey);
        }

        @Override
        public Single<HttpResponse> request(HttpExecutionStrategy strategy, HttpRequest request) {
            return this.connection.request(strategy, request.toStreamingRequest()).flatMap(StreamingHttpResponse::toResponse);
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        public HttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        @Override
        public Completable onClose() {
            return this.connection.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.connection.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.connection.closeAsyncGracefully();
        }

        @Override
        public void close() throws Exception {
            this.connection.close();
        }

        @Override
        public void closeGracefully() throws Exception {
            this.connection.closeGracefully();
        }

        @Override
        public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }
}

