/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConsumableEvent;
import io.servicetalk.client.api.internal.IgnoreConsumedEvent;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.ClientInvoker;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponses;
import io.servicetalk.http.netty.DefaultNettyHttpConnectionContext;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.SpliceFlatStreamToMetaSingle;
import io.servicetalk.transport.netty.internal.FlushStrategies;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class AbstractStreamingHttpConnection<CC extends NettyConnectionContext>
implements FilterableStreamingHttpConnection,
ClientInvoker<FlushStrategy> {
    private static final IgnoreConsumedEvent<Integer> ZERO_MAX_CONCURRECNY_EVENT = new IgnoreConsumedEvent<Integer>(0);
    final CC connection;
    private final HttpConnectionContext connectionContext;
    private final HttpExecutionContext executionContext;
    private final Publisher<? extends ConsumableEvent<Integer>> maxConcurrencySetting;
    private final StreamingHttpRequestResponseFactory reqRespFactory;
    private final HttpHeadersFactory headersFactory;
    private final boolean allowDropTrailersReadFromTransport;

    AbstractStreamingHttpConnection(CC conn, int maxPipelinedRequests, HttpExecutionContext executionContext, StreamingHttpRequestResponseFactory reqRespFactory, HttpHeadersFactory headersFactory, boolean allowDropTrailersReadFromTransport) {
        this.connection = (NettyConnectionContext)Objects.requireNonNull(conn);
        this.connectionContext = new DefaultNettyHttpConnectionContext((NettyConnectionContext)conn, executionContext);
        this.executionContext = Objects.requireNonNull(executionContext);
        this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
        this.maxConcurrencySetting = Publisher.from(new IgnoreConsumedEvent<Integer>(maxPipelinedRequests)).concat(this.connection.onClosing()).concat(Single.succeeded(ZERO_MAX_CONCURRECNY_EVENT));
        this.headersFactory = headersFactory;
        this.allowDropTrailersReadFromTransport = allowDropTrailersReadFromTransport;
    }

    @Override
    public final HttpConnectionContext connectionContext() {
        return this.connectionContext;
    }

    @Override
    public final <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
        return eventKey == HttpEventKey.MAX_CONCURRENCY ? this.maxConcurrencySetting : Publisher.failed(new IllegalArgumentException("Unknown key: " + eventKey));
    }

    @Override
    public final Single<StreamingHttpResponse> invokeClient(Publisher<Object> flattenedRequest, @Nullable FlushStrategy flushStrategy) {
        return this.writeAndRead(flattenedRequest, flushStrategy).liftSyncToSingle(new SpliceFlatStreamToMetaSingle(this::newSplicedResponse));
    }

    @Override
    public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return Single.defer(() -> {
            Publisher<Object> flatRequest;
            if (HeaderUtils.canAddRequestContentLength(request)) {
                flatRequest = HeaderUtils.setRequestContentLength(request);
            } else {
                flatRequest = Publisher.from(request).concat(request.messageBody()).scanWith(HeaderUtils::insertTrailersMapper);
                HeaderUtils.addRequestTransferEncodingIfNecessary(request);
            }
            return strategy.invokeClient(this.executionContext.executor(), flatRequest, AbstractStreamingHttpConnection.determineFlushStrategyForApi(request), this).subscribeShareContext();
        });
    }

    @Nullable
    static FlushStrategy determineFlushStrategyForApi(HttpMetaData request) {
        return HttpApiConversions.isSafeToAggregate(request) ? FlushStrategies.flushOnEnd() : null;
    }

    @Override
    public final HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    protected abstract Publisher<Object> writeAndRead(Publisher<Object> var1, @Nullable FlushStrategy var2);

    private StreamingHttpResponse newSplicedResponse(HttpResponseMetaData meta, Publisher<Object> pub) {
        return StreamingHttpResponses.newTransportResponse(meta.status(), meta.version(), meta.headers(), this.executionContext.bufferAllocator(), pub, this.allowDropTrailersReadFromTransport, this.headersFactory);
    }

    @Override
    public final StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }

    @Override
    public final StreamingHttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public final Completable onClose() {
        return this.connectionContext.onClose();
    }

    @Override
    public final Completable closeAsync() {
        return this.connectionContext.closeAsync();
    }

    @Override
    public final Completable closeAsyncGracefully() {
        return this.connectionContext.closeAsyncGracefully();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.connectionContext + ')';
    }
}

