/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AlpnChannelSingle
extends SubscribableSingle<String> {
    private final Channel channel;
    private final ChannelInitializer channelInitializer;
    private final boolean forceChannelRead;

    AlpnChannelSingle(Channel channel, ChannelInitializer channelInitializer, boolean forceChannelRead) {
        this.channel = channel;
        this.channelInitializer = channelInitializer;
        this.forceChannelRead = forceChannelRead;
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super String> subscriber) {
        try {
            this.channelInitializer.init(this.channel);
        }
        catch (Throwable cause) {
            ChannelCloseUtils.close(this.channel, cause);
            SubscriberUtils.deliverErrorFromSource(subscriber, cause);
            return;
        }
        subscriber.onSubscribe(this.channel::close);
        this.channel.pipeline().addLast(new AlpnChannelHandler(subscriber, this.forceChannelRead));
    }

    static final class NoopChannelInitializer
    implements ChannelInitializer {
        static final ChannelInitializer INSTANCE = new NoopChannelInitializer();

        private NoopChannelInitializer() {
        }

        @Override
        public void init(Channel channel) {
        }

        @Override
        public ChannelInitializer andThen(ChannelInitializer after) {
            return after;
        }
    }

    private static final class AlpnChannelHandler
    extends ApplicationProtocolNegotiationHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(AlpnChannelHandler.class);
        @Nullable
        private SingleSource.Subscriber<? super String> subscriber;
        private final boolean forceRead;

        AlpnChannelHandler(SingleSource.Subscriber<? super String> subscriber, boolean forceRead) {
            super("http/1.1");
            this.subscriber = subscriber;
            this.forceRead = forceRead;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            if (this.forceRead) {
                ctx.read();
            }
        }

        @Override
        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            LOGGER.debug("{} ALPN negotiated {} protocol", (Object)ctx.channel(), (Object)protocol);
            assert (this.subscriber != null);
            SingleSource.Subscriber<? super String> subscriberCopy = this.subscriber;
            this.subscriber = null;
            subscriberCopy.onSuccess(protocol);
        }

        @Override
        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
            LOGGER.warn("{} TLS handshake failed:", (Object)ctx.channel(), (Object)cause);
            this.failSubscriber(cause, ctx.channel());
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOGGER.warn("{} Failed to select the application-level protocol:", (Object)ctx.channel(), (Object)cause);
            if (!this.failSubscriber(cause, ctx.channel())) {
                ctx.fireExceptionCaught(cause);
                ctx.close();
            }
        }

        private boolean failSubscriber(Throwable cause, Channel channel) {
            ChannelCloseUtils.assignConnectionError(channel, cause);
            if (this.subscriber != null) {
                SingleSource.Subscriber<? super String> subscriberCopy = this.subscriber;
                this.subscriber = null;
                subscriberCopy.onError(cause);
                return true;
            }
            return false;
        }
    }
}

