/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;

final class AutoRetryFilter
extends StreamingHttpClientFilter {
    private final AutoRetryStrategyProvider.AutoRetryStrategy retryStrategy;

    AutoRetryFilter(FilterableStreamingHttpClient next, AutoRetryStrategyProvider.AutoRetryStrategy retryStrategy) {
        super(next);
        this.retryStrategy = retryStrategy;
    }

    @Override
    public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
        return this.delegate().reserveConnection(strategy, metaData).retryWhen(this.retryStrategy);
    }

    @Override
    protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return delegate.request(strategy, request).retryWhen(this.retryStrategy);
    }
}

