/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.HttpClientConfig;
import io.servicetalk.http.netty.HttpConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpClientConfig;
import java.util.List;
import javax.annotation.Nullable;

final class ReadOnlyHttpClientConfig {
    private final ReadOnlyTcpClientConfig tcpConfig;
    @Nullable
    private final H1ProtocolConfig h1Config;
    @Nullable
    private final H2ProtocolConfig h2Config;
    @Nullable
    private final CharSequence connectAddress;
    private final boolean allowDropTrailers;

    ReadOnlyHttpClientConfig(HttpClientConfig from) {
        HttpConfig configs = from.protocolConfigs();
        this.tcpConfig = from.tcpConfig().asReadOnly((List)configs.supportedAlpnProtocols());
        this.h1Config = configs.h1Config();
        this.h2Config = configs.h2Config();
        this.connectAddress = from.connectAddress();
        this.allowDropTrailers = configs.allowDropTrailersReadFromTransport();
    }

    ReadOnlyTcpClientConfig tcpConfig() {
        return this.tcpConfig;
    }

    @Nullable
    H1ProtocolConfig h1Config() {
        return this.h1Config;
    }

    @Nullable
    H2ProtocolConfig h2Config() {
        return this.h2Config;
    }

    boolean allowDropTrailersReadFromTransport() {
        return this.allowDropTrailers;
    }

    boolean isH2PriorKnowledge() {
        return this.h2Config != null && this.h1Config == null;
    }

    @Nullable
    CharSequence connectAddress() {
        return this.connectAddress;
    }

    boolean hasProxy() {
        return this.connectAddress != null;
    }
}

