/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.TrailersTransformer;
import io.servicetalk.http.netty.LoadBalancedStreamingHttpClient;
import io.servicetalk.transport.api.HostAndPort;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

final class StreamingHttpRequestWithContext
implements StreamingHttpRequest {
    private final StreamingHttpRequest delegate;
    private final LoadBalancedStreamingHttpClient.OwnedRunnable runnable;

    StreamingHttpRequestWithContext(StreamingHttpRequest delegate, LoadBalancedStreamingHttpClient.OwnedRunnable runnable) {
        this.delegate = delegate;
        this.runnable = runnable;
    }

    LoadBalancedStreamingHttpClient.OwnedRunnable runnable() {
        return this.runnable;
    }

    @Override
    public HttpProtocolVersion version() {
        return this.delegate.version();
    }

    @Override
    public HttpHeaders headers() {
        return this.delegate.headers();
    }

    @Override
    @Nullable
    public ContentCodec encoding() {
        return this.delegate.encoding();
    }

    @Override
    public String toString(BiFunction<? super CharSequence, ? super CharSequence, CharSequence> headerFilter) {
        return this.delegate.toString(headerFilter);
    }

    @Override
    public HttpRequestMethod method() {
        return this.delegate.method();
    }

    @Override
    public String requestTarget() {
        return this.delegate.requestTarget();
    }

    @Override
    public String requestTarget(Charset encoding) {
        return this.delegate.requestTarget(encoding);
    }

    @Override
    @Nullable
    public String scheme() {
        return this.delegate.scheme();
    }

    @Override
    @Nullable
    public String userInfo() {
        return this.delegate.userInfo();
    }

    @Override
    @Nullable
    public String host() {
        return this.delegate.host();
    }

    @Override
    public int port() {
        return this.delegate.port();
    }

    @Override
    public String rawPath() {
        return this.delegate.rawPath();
    }

    @Override
    public String path() {
        return this.delegate.path();
    }

    @Override
    @Nullable
    public String rawQuery() {
        return this.delegate.rawQuery();
    }

    @Override
    @Nullable
    public String query() {
        return this.delegate.query();
    }

    @Override
    @Nullable
    public String queryParameter(String key) {
        return this.delegate.queryParameter(key);
    }

    @Override
    public Iterable<Map.Entry<String, String>> queryParameters() {
        return this.delegate.queryParameters();
    }

    @Override
    public Iterable<String> queryParameters(String key) {
        return this.delegate.queryParameters(key);
    }

    @Override
    public Iterator<String> queryParametersIterator(String key) {
        return this.delegate.queryParametersIterator(key);
    }

    @Override
    public Set<String> queryParametersKeys() {
        return this.delegate.queryParametersKeys();
    }

    @Override
    public boolean hasQueryParameter(String key) {
        return this.delegate.hasQueryParameter(key);
    }

    @Override
    public boolean hasQueryParameter(String key, String value) {
        return this.delegate.hasQueryParameter(key, value);
    }

    @Override
    public int queryParametersSize() {
        return this.delegate.queryParametersSize();
    }

    @Override
    public boolean removeQueryParameters(String key) {
        return this.delegate.removeQueryParameters(key);
    }

    @Override
    public boolean removeQueryParameters(String key, String value) {
        return this.delegate.removeQueryParameters(key, value);
    }

    @Override
    @Nullable
    public HostAndPort effectiveHostAndPort() {
        return this.delegate.effectiveHostAndPort();
    }

    @Override
    public Publisher<Buffer> payloadBody() {
        return this.delegate.payloadBody();
    }

    @Override
    public <T> Publisher<T> payloadBody(HttpDeserializer<T> deserializer) {
        return this.delegate.payloadBody(deserializer);
    }

    @Override
    public Publisher<Object> payloadBodyAndTrailers() {
        return this.delegate.payloadBodyAndTrailers();
    }

    @Override
    public Publisher<Object> messageBody() {
        return this.delegate.messageBody();
    }

    @Override
    public StreamingHttpRequest payloadBody(Publisher<Buffer> payloadBody) {
        this.delegate.payloadBody(payloadBody);
        return this;
    }

    @Override
    public <T> StreamingHttpRequest payloadBody(Publisher<T> payloadBody, HttpSerializer<T> serializer) {
        this.delegate.payloadBody(payloadBody, serializer);
        return this;
    }

    @Override
    public <T> StreamingHttpRequest transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpSerializer<T> serializer) {
        this.delegate.transformPayloadBody(transformer, serializer);
        return this;
    }

    @Override
    public <T, R> StreamingHttpRequest transformPayloadBody(Function<Publisher<T>, Publisher<R>> transformer, HttpDeserializer<T> deserializer, HttpSerializer<R> serializer) {
        this.delegate.transformPayloadBody(transformer, deserializer, serializer);
        return this;
    }

    @Override
    public StreamingHttpRequest transformPayloadBody(UnaryOperator<Publisher<Buffer>> transformer) {
        this.delegate.transformPayloadBody(transformer);
        return this;
    }

    @Override
    public StreamingHttpRequest transformRawPayloadBody(UnaryOperator<Publisher<?>> transformer) {
        this.delegate.transformRawPayloadBody(transformer);
        return this;
    }

    @Override
    public StreamingHttpRequest transformMessageBody(UnaryOperator<Publisher<?>> transformer) {
        this.delegate.transformMessageBody(transformer);
        return this;
    }

    @Override
    public <T> StreamingHttpRequest transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.delegate.transform(trailersTransformer);
        return this;
    }

    @Override
    public <T> StreamingHttpRequest transformRaw(TrailersTransformer<T, Object> trailersTransformer) {
        this.delegate.transformRaw(trailersTransformer);
        return this;
    }

    @Override
    public Single<HttpRequest> toRequest() {
        return this.delegate.toRequest();
    }

    @Override
    public BlockingStreamingHttpRequest toBlockingStreamingRequest() {
        return this.delegate.toBlockingStreamingRequest();
    }

    @Override
    public StreamingHttpRequest rawPath(String path) {
        this.delegate.rawPath(path);
        return this;
    }

    @Override
    public StreamingHttpRequest path(String path) {
        this.delegate.path(path);
        return this;
    }

    @Override
    public StreamingHttpRequest appendPathSegments(String ... segments) {
        this.delegate.appendPathSegments(segments);
        return this;
    }

    @Override
    public StreamingHttpRequest rawQuery(@Nullable String query) {
        this.delegate.rawQuery(query);
        return this;
    }

    @Override
    public StreamingHttpRequest query(@Nullable String query) {
        this.delegate.query(query);
        return this;
    }

    @Override
    public StreamingHttpRequest addQueryParameter(String key, String value) {
        this.delegate.addQueryParameter(key, value);
        return this;
    }

    @Override
    public StreamingHttpRequest addQueryParameters(String key, Iterable<String> values) {
        this.delegate.addQueryParameters(key, (Iterable)values);
        return this;
    }

    @Override
    public StreamingHttpRequest addQueryParameters(String key, String ... values) {
        this.delegate.addQueryParameters(key, values);
        return this;
    }

    @Override
    public StreamingHttpRequest setQueryParameter(String key, String value) {
        this.delegate.setQueryParameter(key, value);
        return this;
    }

    @Override
    public StreamingHttpRequest setQueryParameters(String key, Iterable<String> values) {
        this.delegate.setQueryParameters(key, (Iterable)values);
        return this;
    }

    @Override
    public StreamingHttpRequest setQueryParameters(String key, String ... values) {
        this.delegate.setQueryParameters(key, values);
        return this;
    }

    @Override
    public StreamingHttpRequest version(HttpProtocolVersion version) {
        this.delegate.version(version);
        return this;
    }

    @Override
    public StreamingHttpRequest method(HttpRequestMethod method) {
        this.delegate.method(method);
        return this;
    }

    @Override
    public StreamingHttpRequest encoding(ContentCodec encoding) {
        this.delegate.encoding(encoding);
        return this;
    }

    @Override
    public StreamingHttpRequest requestTarget(String requestTarget) {
        this.delegate.requestTarget(requestTarget);
        return this;
    }

    @Override
    public StreamingHttpRequest requestTarget(String requestTarget, Charset encoding) {
        this.delegate.requestTarget(requestTarget, encoding);
        return this;
    }

    @Override
    public StreamingHttpRequest addHeader(CharSequence name, CharSequence value) {
        this.delegate.addHeader(name, value);
        return this;
    }

    @Override
    public StreamingHttpRequest addHeaders(HttpHeaders headers) {
        this.delegate.addHeaders(headers);
        return this;
    }

    @Override
    public StreamingHttpRequest setHeader(CharSequence name, CharSequence value) {
        this.delegate.setHeader(name, value);
        return this;
    }

    @Override
    public StreamingHttpRequest setHeaders(HttpHeaders headers) {
        this.delegate.setHeaders(headers);
        return this;
    }

    @Override
    public StreamingHttpRequest addCookie(HttpCookiePair cookie) {
        this.delegate.addCookie(cookie);
        return this;
    }

    @Override
    public StreamingHttpRequest addCookie(CharSequence name, CharSequence value) {
        this.delegate.addCookie(name, value);
        return this;
    }

    @Override
    public StreamingHttpRequest addSetCookie(HttpSetCookie cookie) {
        this.delegate.addSetCookie(cookie);
        return this;
    }

    @Override
    public StreamingHttpRequest addSetCookie(CharSequence name, CharSequence value) {
        this.delegate.addSetCookie(name, value);
        return this;
    }
}

