/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.handler.ssl.SslContext;
import io.servicetalk.tcp.netty.internal.AbstractReadOnlyTcpConfig;
import io.servicetalk.tcp.netty.internal.TcpClientConfig;
import io.servicetalk.transport.netty.internal.ReadOnlyClientSecurityConfig;
import io.servicetalk.transport.netty.internal.SslContextFactory;
import java.util.List;
import javax.annotation.Nullable;

public final class ReadOnlyTcpClientConfig
extends AbstractReadOnlyTcpConfig<ReadOnlyClientSecurityConfig, ReadOnlyTcpClientConfig> {
    @Nullable
    private final SslContext sslContext;
    @Nullable
    private final String sslHostnameVerificationAlgorithm;
    @Nullable
    private final String sslHostnameVerificationHost;
    private final int sslHostnameVerificationPort;

    ReadOnlyTcpClientConfig(TcpClientConfig from, List<String> supportedAlpnProtocols) {
        super(from, supportedAlpnProtocols.isEmpty() ? null : supportedAlpnProtocols.get(0));
        ReadOnlyClientSecurityConfig securityConfig = (ReadOnlyClientSecurityConfig)from.securityConfig();
        if (securityConfig != null) {
            this.sslContext = SslContextFactory.forClient(securityConfig, supportedAlpnProtocols);
            this.sslHostnameVerificationAlgorithm = securityConfig.hostnameVerificationAlgorithm();
            this.sslHostnameVerificationHost = securityConfig.hostnameVerificationHost();
            this.sslHostnameVerificationPort = securityConfig.hostnameVerificationPort();
        } else {
            this.sslContext = null;
            this.sslHostnameVerificationAlgorithm = null;
            this.sslHostnameVerificationHost = null;
            this.sslHostnameVerificationPort = -1;
        }
    }

    @Override
    @Nullable
    public SslContext sslContext() {
        return this.sslContext;
    }

    @Nullable
    public String sslHostnameVerificationAlgorithm() {
        return this.sslHostnameVerificationAlgorithm;
    }

    @Nullable
    public String sslHostnameVerificationHost() {
        return this.sslHostnameVerificationHost;
    }

    public int sslHostnameVerificationPort() {
        return this.sslHostnameVerificationPort;
    }
}

