/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import io.servicetalk.tcp.netty.internal.AbstractReadOnlyTcpConfig;
import io.servicetalk.tcp.netty.internal.TcpServerConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.api.TransportObservers;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.ReadOnlyServerSecurityConfig;
import io.servicetalk.transport.netty.internal.SslContextFactory;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ReadOnlyTcpServerConfig
extends AbstractReadOnlyTcpConfig<ReadOnlyServerSecurityConfig, ReadOnlyTcpServerConfig> {
    private final TransportObserver transportObserver;
    @Nullable
    private final SslContext sslContext;
    @Nullable
    private final DomainNameMapping<SslContext> mappings;
    private final int backlog;

    ReadOnlyTcpServerConfig(TcpServerConfig from, List<String> supportedAlpnProtocols) {
        super(from, supportedAlpnProtocols.isEmpty() ? null : supportedAlpnProtocols.get(0));
        TransportObserver transportObserver = from.transportObserver();
        this.transportObserver = transportObserver == NoopTransportObserver.INSTANCE ? transportObserver : TransportObservers.asSafeObserver(transportObserver);
        ReadOnlyServerSecurityConfig securityConfig = (ReadOnlyServerSecurityConfig)from.securityConfig();
        if (from.sniConfigs() != null) {
            if (securityConfig == null) {
                throw new IllegalStateException("No default security config defined but found SNI config mappings");
            }
            this.sslContext = SslContextFactory.forServer(securityConfig, supportedAlpnProtocols);
            DomainNameMappingBuilder<SslContext> mappingBuilder = new DomainNameMappingBuilder<SslContext>(this.sslContext);
            for (Map.Entry<String, ReadOnlyServerSecurityConfig> sniConfigEntries : from.sniConfigs().entrySet()) {
                mappingBuilder.add(sniConfigEntries.getKey(), SslContextFactory.forServer(sniConfigEntries.getValue(), supportedAlpnProtocols));
            }
            this.mappings = mappingBuilder.build();
        } else if (securityConfig != null) {
            this.sslContext = SslContextFactory.forServer(securityConfig, supportedAlpnProtocols);
            this.mappings = null;
        } else {
            this.sslContext = null;
            this.mappings = null;
        }
        this.backlog = from.backlog();
    }

    public TransportObserver transportObserver() {
        return this.transportObserver;
    }

    @Override
    @Nullable
    public SslContext sslContext() {
        return this.sslContext;
    }

    @Nullable
    public DomainNameMapping<SslContext> domainNameMapping() {
        return this.mappings;
    }

    public int backlog() {
        return this.backlog;
    }
}

