/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.util.NetUtil;
import io.servicetalk.tcp.netty.internal.AbstractTcpConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.ReadOnlyServerSecurityConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TcpServerConfig
extends AbstractTcpConfig<ReadOnlyServerSecurityConfig, ReadOnlyTcpServerConfig> {
    private TransportObserver transportObserver = NoopTransportObserver.INSTANCE;
    @Nullable
    private Map<String, ReadOnlyServerSecurityConfig> sniConfigs;
    private int backlog = NetUtil.SOMAXCONN;

    TransportObserver transportObserver() {
        return this.transportObserver;
    }

    @Nullable
    Map<String, ReadOnlyServerSecurityConfig> sniConfigs() {
        return this.sniConfigs;
    }

    int backlog() {
        return this.backlog;
    }

    public void transportObserver(TransportObserver transportObserver) {
        this.transportObserver = Objects.requireNonNull(transportObserver);
    }

    public TcpServerConfig secure(ReadOnlyServerSecurityConfig securityConfig, String ... sniHostnames) {
        Objects.requireNonNull(securityConfig);
        Objects.requireNonNull(sniHostnames);
        if (this.sniConfigs == null) {
            this.sniConfigs = new HashMap<String, ReadOnlyServerSecurityConfig>();
        }
        for (String sniHostname : sniHostnames) {
            this.sniConfigs.put(sniHostname, securityConfig);
        }
        return this;
    }

    public TcpServerConfig backlog(int backlog) {
        if (backlog < 0) {
            throw new IllegalArgumentException("backlog must be >= 0");
        }
        this.backlog = backlog;
        return this;
    }

    @Override
    public ReadOnlyTcpServerConfig asReadOnly(List<String> supportedAlpnProtocols) {
        return new ReadOnlyTcpServerConfig(this, supportedAlpnProtocols);
    }
}

