/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import java.util.Objects;

public final class DefaultExecutionContext
implements ExecutionContext {
    private final BufferAllocator bufferAllocator;
    private final IoExecutor ioExecutor;
    private final Executor executor;
    private final ExecutionStrategy executionStrategy;

    public DefaultExecutionContext(BufferAllocator bufferAllocator, IoExecutor ioExecutor, Executor executor, ExecutionStrategy executionStrategy) {
        this.bufferAllocator = Objects.requireNonNull(bufferAllocator);
        this.ioExecutor = Objects.requireNonNull(ioExecutor);
        this.executor = Objects.requireNonNull(executor);
        this.executionStrategy = Objects.requireNonNull(executionStrategy);
    }

    @Override
    public BufferAllocator bufferAllocator() {
        return this.bufferAllocator;
    }

    @Override
    public IoExecutor ioExecutor() {
        return this.ioExecutor;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    @Override
    public ExecutionStrategy executionStrategy() {
        return this.executionStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultExecutionContext that = (DefaultExecutionContext)o;
        if (!this.bufferAllocator.equals(that.bufferAllocator)) {
            return false;
        }
        if (!this.ioExecutor.equals(that.ioExecutor)) {
            return false;
        }
        if (!this.executor.equals(that.executor)) {
            return false;
        }
        return this.executionStrategy.equals(that.executionStrategy);
    }

    public int hashCode() {
        int result = this.bufferAllocator.hashCode();
        result = 31 * result + this.ioExecutor.hashCode();
        result = 31 * result + this.executor.hashCode();
        result = 31 * result + this.executionStrategy.hashCode();
        return result;
    }
}

